jQuery(document).ready(function () {
    jQuery('.accountino-single-product .e-n-tabs-heading > button').click(function () {
        sectionId = this.id;

        sectionBox = document.querySelector(`[aria-labelledby="${sectionId}"]:has(div)`);

        sectionBox.scrollIntoView({ 'behavior': 'smooth' });
    })


    jQuery(document).on('click', '.qty-plus', function () {
        let $qty = jQuery(this).next('.qty');
        let val = parseInt($qty.val());
        $qty.val(val + 1).change();
    });

    jQuery(document).on('click', '.qty-minus', function () {
        let $qty = jQuery(this).prev('.qty');
        let val = parseInt($qty.val());
        if (val > 1) $qty.val(val - 1).change();
    });

    setTimeout(() => {
        jQuery('[name="update_cart"]').attr('disabled', false);
    }, 1000);
})


function favoritePost(postId) {
    const favoriteIcon = jQuery(`[data-favorite][data-id="${postId}"]`);
    const checkFavorite = jQuery(`[data-favorite="true"][data-id="${postId}"]`).length;
    favoriteIcon.css({
        'opacity': .5,
        'pointer-events': 'none'
    });
    jQuery.post(ajaxUrl, {
        action: 'accountino_post_favorite',
        post_id: postId,
    }, function (response) {
        if (response.success) {
            if (checkFavorite) {
                favoriteIcon.removeClass('fas').addClass('far').attr('data-favorite', 'false');
            } else {
                favoriteIcon.removeClass('far').addClass('fas').attr('data-favorite', 'true');
            }
        }

        favoriteIcon.css({
            'opacity': 1,
            'pointer-events': 'all'
        });
    });
}