<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Rest\Preview\AccSecurity as PreviewAccSecurity;
use Twilio\Rest\Preview\BulkExports as PreviewBulkExports;
use Twilio\Rest\Preview\BulkExports\ExportConfigurationContext;
use Twilio\Rest\Preview\BulkExports\ExportConfigurationList;
use Twilio\Rest\Preview\BulkExports\ExportContext;
use Twilio\Rest\Preview\BulkExports\ExportList;
use Twilio\Rest\Preview\DeployedDevices as PreviewDeployedDevices;
use Twilio\Rest\Preview\DeployedDevices\FleetContext;
use Twilio\Rest\Preview\DeployedDevices\FleetList;
use Twilio\Rest\Preview\HostedNumbers as PreviewHostedNumbers;
use Twilio\Rest\Preview\HostedNumbers\AuthorizationDocumentContext;
use Twilio\Rest\Preview\HostedNumbers\AuthorizationDocumentList;
use Twilio\Rest\Preview\HostedNumbers\HostedNumberOrderContext;
use Twilio\Rest\Preview\HostedNumbers\HostedNumberOrderList;
use Twilio\Rest\Preview\Marketplace as PreviewMarketplace;
use Twilio\Rest\Preview\Marketplace\AvailableAddOnContext;
use Twilio\Rest\Preview\Marketplace\AvailableAddOnList;
use Twilio\Rest\Preview\Marketplace\InstalledAddOnContext;
use Twilio\Rest\Preview\Marketplace\InstalledAddOnList;
use Twilio\Rest\Preview\Sync as PreviewSync;
use Twilio\Rest\Preview\Sync\ServiceContext;
use Twilio\Rest\Preview\Sync\ServiceList;
use Twilio\Rest\Preview\Understand as PreviewUnderstand;
use Twilio\Rest\Preview\Understand\AssistantContext;
use Twilio\Rest\Preview\Understand\AssistantList;
use Twilio\Rest\Preview\Wireless as PreviewWireless;
use Twilio\Rest\Preview\Wireless\CommandContext;
use Twilio\Rest\Preview\Wireless\CommandList;
use Twilio\Rest\Preview\Wireless\RatePlanContext;
use Twilio\Rest\Preview\Wireless\RatePlanList;
use Twilio\Rest\Preview\Wireless\SimContext;
use Twilio\Rest\Preview\Wireless\SimList;
use Twilio\Version;

/**
 * @property PreviewBulkExports bulkExports
 * @property PreviewDeployedDevices deployedDevices
 * @property PreviewHostedNumbers hostedNumbers
 * @property PreviewMarketplace marketplace
 * @property PreviewAccSecurity accSecurity
 * @property PreviewSync sync
 * @property PreviewUnderstand understand
 * @property PreviewWireless wireless
 * @property ExportList exports
 * @property ExportConfigurationList exportConfiguration
 * @property FleetList fleets
 * @property AuthorizationDocumentList authorizationDocuments
 * @property HostedNumberOrderList hostedNumberOrders
 * @property InstalledAddOnList installedAddOns
 * @property AvailableAddOnList availableAddOns
 * @property ServiceList services
 * @property AssistantList assistants
 * @property CommandList commands
 * @property RatePlanList ratePlans
 * @property SimList sims
 * @method ExportContext exports(string $resourceType)
 * @method ExportConfigurationContext exportConfiguration(string $resourceType)
 * @method FleetContext fleets(string $sid)
 * @method AuthorizationDocumentContext authorizationDocuments(string $sid)
 * @method HostedNumberOrderContext hostedNumberOrders(string $sid)
 * @method InstalledAddOnContext installedAddOns(string $sid)
 * @method AvailableAddOnContext availableAddOns(string $sid)
 * @method ServiceContext services(string $sid)
 * @method AssistantContext assistants(string $sid)
 * @method CommandContext commands(string $sid)
 * @method RatePlanContext ratePlans(string $sid)
 * @method SimContext sims(string $sid)
 */
class Preview extends Domain {
    protected $_bulkExports = null;
    protected $_deployedDevices = null;
    protected $_hostedNumbers = null;
    protected $_marketplace = null;
    protected $_accSecurity = null;
    protected $_sync = null;
    protected $_understand = null;
    protected $_wireless = null;

    /**
     * Construct the Preview Domain
     * 
     * @param Client $client Twilio\Rest\Client to communicate with
     *                                    Twilio
     * @return Preview Domain for Preview
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://preview.twilio.com';
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     *
     * @return Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get($name) {
        $method = 'get' . ucfirst($name);
        if (method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     *
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call($name, $arguments) {
        $method = 'context' . ucfirst($name);
        if (method_exists($this, $method)) {
            return call_user_func_array(array($this, $method), $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.Preview]';
    }

    /**
     * @return PreviewBulkExports Version bulkExports of preview
     */
    protected function getBulkExports() {
        if (!$this->_bulkExports) {
            $this->_bulkExports = new PreviewBulkExports($this);
        }
        return $this->_bulkExports;
    }

    /**
     * @return PreviewDeployedDevices Version deployedDevices of
     *                                              preview
     */
    protected function getDeployedDevices() {
        if (!$this->_deployedDevices) {
            $this->_deployedDevices = new PreviewDeployedDevices($this);
        }
        return $this->_deployedDevices;
    }

    /**
     * @return PreviewHostedNumbers Version hostedNumbers of preview
     */
    protected function getHostedNumbers() {
        if (!$this->_hostedNumbers) {
            $this->_hostedNumbers = new PreviewHostedNumbers($this);
        }
        return $this->_hostedNumbers;
    }

    /**
     * @return PreviewMarketplace Version marketplace of preview
     */
    protected function getMarketplace() {
        if (!$this->_marketplace) {
            $this->_marketplace = new PreviewMarketplace($this);
        }
        return $this->_marketplace;
    }

    /**
     * @return PreviewAccSecurity Version accSecurity of preview
     */
    protected function getAccSecurity() {
        if (!$this->_accSecurity) {
            $this->_accSecurity = new PreviewAccSecurity($this);
        }
        return $this->_accSecurity;
    }

    /**
     * @return PreviewSync Version sync of preview
     */
    protected function getSync() {
        if (!$this->_sync) {
            $this->_sync = new PreviewSync($this);
        }
        return $this->_sync;
    }

    /**
     * @return PreviewUnderstand Version understand of preview
     */
    protected function getUnderstand() {
        if (!$this->_understand) {
            $this->_understand = new PreviewUnderstand($this);
        }
        return $this->_understand;
    }

    /**
     * @return PreviewWireless Version wireless of preview
     */
    protected function getWireless() {
        if (!$this->_wireless) {
            $this->_wireless = new PreviewWireless($this);
        }
        return $this->_wireless;
    }

    /**
     * @return ExportList
     */
    protected function getExports() {
        return $this->bulkExports->exports;
    }

    /**
     * @param string $resourceType The resource_type
     * @return ExportContext
     */
    protected function contextExports($resourceType) {
        return $this->bulkExports->exports($resourceType);
    }

    /**
     * @return ExportConfigurationList
     */
    protected function getExportConfiguration() {
        return $this->bulkExports->exportConfiguration;
    }

    /**
     * @param string $resourceType The resource_type
     * @return ExportConfigurationContext
     */
    protected function contextExportConfiguration($resourceType) {
        return $this->bulkExports->exportConfiguration($resourceType);
    }

    /**
     * @return FleetList
     */
    protected function getFleets() {
        return $this->deployedDevices->fleets;
    }

    /**
     * @param string $sid A string that uniquely identifies the Fleet.
     * @return FleetContext
     */
    protected function contextFleets($sid) {
        return $this->deployedDevices->fleets($sid);
    }

    /**
     * @return AuthorizationDocumentList
     */
    protected function getAuthorizationDocuments() {
        return $this->hostedNumbers->authorizationDocuments;
    }

    /**
     * @param string $sid AuthorizationDocument sid.
     * @return AuthorizationDocumentContext
     */
    protected function contextAuthorizationDocuments($sid) {
        return $this->hostedNumbers->authorizationDocuments($sid);
    }

    /**
     * @return HostedNumberOrderList
     */
    protected function getHostedNumberOrders() {
        return $this->hostedNumbers->hostedNumberOrders;
    }

    /**
     * @param string $sid HostedNumberOrder sid.
     * @return HostedNumberOrderContext
     */
    protected function contextHostedNumberOrders($sid) {
        return $this->hostedNumbers->hostedNumberOrders($sid);
    }

    /**
     * @return InstalledAddOnList
     */
    protected function getInstalledAddOns() {
        return $this->marketplace->installedAddOns;
    }

    /**
     * @param string $sid The unique Installed Add-on Sid
     * @return InstalledAddOnContext
     */
    protected function contextInstalledAddOns($sid) {
        return $this->marketplace->installedAddOns($sid);
    }

    /**
     * @return AvailableAddOnList
     */
    protected function getAvailableAddOns() {
        return $this->marketplace->availableAddOns;
    }

    /**
     * @param string $sid The unique Available Add-on Sid
     * @return AvailableAddOnContext
     */
    protected function contextAvailableAddOns($sid) {
        return $this->marketplace->availableAddOns($sid);
    }

    /**
     * @return ServiceList
     */
    protected function getServices() {
        return $this->sync->services;
    }

    /**
     * @param string $sid The sid
     * @return ServiceContext
     */
    protected function contextServices($sid) {
        return $this->sync->services($sid);
    }

    /**
     * @return AssistantList
     */
    protected function getAssistants() {
        return $this->understand->assistants;
    }

    /**
     * @param string $sid A 34 character string that uniquely identifies this
     *                    resource.
     * @return AssistantContext
     */
    protected function contextAssistants($sid) {
        return $this->understand->assistants($sid);
    }

    /**
     * @return CommandList
     */
    protected function getCommands() {
        return $this->wireless->commands;
    }

    /**
     * @param string $sid The sid
     * @return CommandContext
     */
    protected function contextCommands($sid) {
        return $this->wireless->commands($sid);
    }

    /**
     * @return RatePlanList
     */
    protected function getRatePlans() {
        return $this->wireless->ratePlans;
    }

    /**
     * @param string $sid The sid
     * @return RatePlanContext
     */
    protected function contextRatePlans($sid) {
        return $this->wireless->ratePlans($sid);
    }

    /**
     * @return SimList
     */
    protected function getSims() {
        return $this->wireless->sims;
    }

    /**
     * @param string $sid The sid
     * @return SimContext
     */
    protected function contextSims($sid) {
        return $this->wireless->sims($sid);
    }
}