<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Rest\Lookups\V1;
use Twilio\Rest\Lookups\V1\PhoneNumberContext;
use Twilio\Rest\Lookups\V1\PhoneNumberList;
use Twilio\Version;

/**
 * @property V1 v1
 * @property PhoneNumberList phoneNumbers
 * @method PhoneNumberContext phoneNumbers(string $phoneNumber)
 */
class Lookups extends Domain {
    protected $_v1 = null;

    /**
     * Construct the Lookups Domain
     * 
     * @param Client $client Twilio\Rest\Client to communicate with
     *                                    Twilio
     * @return Lookups Domain for Lookups
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://lookups.twilio.com';
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     *
     * @return Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get($name) {
        $method = 'get' . ucfirst($name);
        if (method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     *
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call($name, $arguments) {
        $method = 'context' . ucfirst($name);
        if (method_exists($this, $method)) {
            return call_user_func_array(array($this, $method), $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.Lookups]';
    }

    /**
     * @return V1 Version v1 of lookups
     */
    protected function getV1() {
        if (!$this->_v1) {
            $this->_v1 = new V1($this);
        }
        return $this->_v1;
    }

    /**
     * @return PhoneNumberList
     */
    protected function getPhoneNumbers() {
        return $this->v1->phoneNumbers;
    }

    /**
     * @param string $phoneNumber The phone_number
     * @return PhoneNumberContext
     */
    protected function contextPhoneNumbers($phoneNumber) {
        return $this->v1->phoneNumbers($phoneNumber);
    }
}