<?php

namespace AccountinoCore\Modules\WoocommerceCart;

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

class Module
{

	public function __construct()
	{
		add_action('wp_ajax_accountino_update_cart_qty', [$this, 'updateCartQuantity']);
		add_action('wp_ajax_nopriv_accountino_update_cart_qty', [$this, 'updateCartQuantity']);

		add_action('wp_ajax_accountino_refresh_cart_widget', [$this, 'refreshCart']);
		add_action('wp_ajax_nopriv_accountino_refresh_cart_widget', [$this, 'refreshCart']);
	}

	public static function updateCartQuantity()
	{
		if (!isset($_POST['cart_key']) || !isset($_POST['quantity'])) wp_die();

		$cart_key = sanitize_text_field($_POST['cart_key']);
		$qty = (int) $_POST['quantity'];

		if ($qty <= 0) {
			WC()->cart->remove_cart_item($cart_key);
		} else {
			WC()->cart->set_quantity($cart_key, $qty, true);
		}

		wp_send_json_success(WC()->cart->get_cart_contents_count());
	}

	public static function refreshCart()
	{
		include(ACCOUNTINO_CORE_PATH . '/elementor_widgets/woocommerce-cart/woocommerce-cart-details.php');
		wp_die();
	}



	public static function is_active()
	{
		return false;
	}

	public static function get_experimental_data()
	{
		return null;
	}
}


new Module();
