<?php

namespace AccountinoCore\Modules\MegaMenu;

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

class Module
{

	public function __construct()
	{
		add_filter('wp_nav_menu_item_custom_fields', [$this, 'showCustomField'], 10, 4);
		add_action('wp_update_nav_menu_item', [$this, 'saveCustomField'], 10, 4);
	}

	public function showCustomField($item_id, $item, $depth, $args)
	{
		if ($depth > 0) return;
		$template = get_post_meta($item_id, '_mega_menu_template', true); ?>
		<p class="field-custom description description-wide">
			<label for="edit-menu-item-mega-menu-template-<?php echo $item_id; ?>">
				طرح المنتور برای مگامنو<br>(یک قالب ایجاد شده در پنل قالب اکانت پرو > کتابخانه من را انتخاب کنید.
				)

				<select name="menu-item-mega-menu-template[<?php echo $item_id; ?>]" class="edit-menu-item-mega_menu widefat" id="edit-menu-item-mega-menu-template-<?php echo $item_id; ?>">
					<option value="">انتخاب</option>
					<?php
					$libraries = get_posts(array('post_type' => 'accountino_library', 'numberposts' => -1, 'post_status' => 'publish'));
					foreach ($libraries as $library) {
						echo "<option value='{$library->ID}' " . ($template == $library->ID ? 'selected' : '') . ">{$library->post_title}</option>";
					}
					?>
				</select>
			</label>
		</p>
<?php
	}

	public function saveCustomField($menu_id, $menu_item_db_id, $args)
	{

		if (isset($_POST['menu-item-mega-menu-template'][$menu_item_db_id])) {
			update_post_meta($menu_item_db_id, '_mega_menu_template', sanitize_text_field($_POST['menu-item-mega-menu-template'][$menu_item_db_id]));
		}
	}

	public static function is_active()
	{
		return false;
	}

	public static function get_experimental_data()
	{
		return null;
	}
}


new Module();
