<?php
add_filter('wp_nav_menu_item_custom_fields', function ($item_id, $item, $depth, $args) {
    if ($depth > 0) return;
    $template = get_post_meta($item_id, '_child_template', true);
?>
    <p class="field-custom description description-wide">
        <label for="edit-menu-item-icon-<?php echo $item_id; ?>">
            طرح المنتور برای مگامنو<br>(یک قالب ایجاد شده در پنل قالب اکانت پرو > کتابخانه من را انتخاب کنید.
            )

            <select name="menu-item-icon[<?php echo $item_id; ?>]" class="edit-menu-item-mega_menu widefat" id="edit-menu-item-icon-<?php echo $item_id; ?>">
                <option value="">انتخاب</option>
                <?php
                $libraries = get_posts(array('post_type' => 'accountino_library', 'numberposts' => -1, 'post_status' => 'publish'));
                foreach ($libraries as $library) {
                    echo "<option value='{$library->ID}' " . ($template == $library->ID ? 'selected' : '') . ">{$library->post_title}</option>";
                }
                ?>
            </select>
        </label>
    </p>
<?php
}, 10, 4);
