<?php

namespace AccountinoCore\Modules\Login;

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

class Module
{

	public function __construct()
	{
		add_action('init', [$this, 'handleLogin']);
		add_action('init', [$this, 'handleSignup']);
	}

	public function handleLogin()
	{
		if (!empty($_POST['accountino_login_nonce']) && wp_verify_nonce($_POST['accountino_login_nonce'], 'accountino_login')) {
			$creds = array(
				'user_login' => sanitize_user($_POST['username']),
				'user_password' => $_POST['password'],
				'remember' => isset($_POST['remember']) ? true : false,
			);

			$user = wp_signon($creds, false);

			if (is_wp_error($user)) {
				add_action('accountino_login_display_errors', function () use ($user) {
					echo '<div class="accountino-login-error">' . $user->get_error_message() . '</div>';
				});
			} else {
				wp_redirect(home_url());
				exit;
			}
		}
	}

	public function handleSignup()
	{
		if (!empty($_POST['accountino_signup_nonce']) && wp_verify_nonce($_POST['accountino_signup_nonce'], 'accountino_signup')) {
			$phone = sanitize_text_field($_POST['phone']);
			$password = $_POST['password'];
			$repeat_password = $_POST['password'];
			$full_name = sanitize_text_field($_POST['full_name']);

			$errors = new \WP_Error();

			if (username_exists($phone)) {
				$errors->add('phone', esc_html__('این شماره تلفن قبلا ثبت شده است', ACCOUNTINO_CORE_WIDGETS_PANEL));
			}
			if (empty($password) || empty($repeat_password)) {
				$errors->add('password', esc_html__('رمز عبور الزامی است.', ACCOUNTINO_CORE_WIDGETS_PANEL));
			}
			if ($password !== $repeat_password) {
				$errors->add('repeat_password', esc_html__('رمز عبور یکسان نیست.', ACCOUNTINO_CORE_WIDGETS_PANEL));
			}

			if (empty($errors->errors)) {
				$user_id = wp_create_user($phone, $password);
				if (!is_wp_error($user_id)) {
					wp_update_user(['ID' => $user_id, 'first_name' => $full_name, 'display_name' => $full_name]);

					add_action('accountino_register_display_errors', function () {
						echo '<div class="accountino-signup-success">حساب کاربری با موفقیت ایجاد شد.</div>';
					});
				}
			} else {
				add_action('accountino_register_display_errors', function () use ($errors) {
					foreach ($errors->get_error_messages() as $error) {
						echo '<div class="accountino-signup-error">' . esc_html($error) . '</div>';
					}
				});
			}
		}
	}

	public static function is_active()
	{
		return false;
	}

	public static function get_experimental_data()
	{
		return null;
	}
}


new Module();
