<?php

namespace AccountinoCore\Modules\Form;

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

class Module
{

	public function __construct()
	{
		add_action("wp_ajax_nopriv_accountino_ajax_contact_form", [$this, "submitContactUs"]);
		add_action("wp_ajax_accountino_ajax_contact_form", [$this, "submitContactUs"]);
	}

	public function submitContactUs()
	{

		$message = "";
		foreach ($_POST as $key => $value) {
			if (in_array($key, ['action', 'form_id'])) continue;
			$message .= ucfirst(str_replace('_', ' ', $key)) . ': ' . sanitize_text_field($value) . "\n";
		}

		wp_mail(get_option('admin_email'), 'فرم تماس با ما', $message);
		wp_send_json_success(__('پیام شما با موفقیت ارسال شد.!', ACCOUNTINO_CORE_WIDGETS_PANEL));
	}


	public static function is_active()
	{
		return false;
	}

	public static function get_experimental_data()
	{
		return null;
	}
}


new Module();
