<?php

namespace AccountinoCore\Modules\DynamicTags\Tags;

use Elementor\Controls_Manager;
use AccountinoCore\Modules\DynamicTags\Tags\Base\Data_Tag;
use AccountinoCore\Modules\DynamicTags\Module;

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

class Post_Featured_Image extends Data_Tag
{

	public function get_name()
	{
		return 'post-featured-image';
	}

	public function get_group()
	{
		return Module::POST_GROUP;
	}

	public function get_categories()
	{
		return [Module::IMAGE_CATEGORY];
	}

	public function get_title()
	{
		return esc_html__('Featured Image', 'elementor-pro');
	}

	public function get_value(array $options = [])
	{
		$thumbnail_id = get_post_thumbnail_id();

		if ($thumbnail_id) {
			$image_data = [
				'id' => $thumbnail_id,
				'url' => wp_get_attachment_image_src($thumbnail_id, 'full')[0],
			];
		} else {
			$image_data = $this->get_settings('fallback');
		}

		return $image_data;
	}

	protected function register_controls()
	{
		$this->add_control(
			'fallback',
			[
				'label' => esc_html__('Fallback', 'elementor-pro'),
				'type' => Controls_Manager::MEDIA,
			]
		);
	}
}
