<?php

namespace AccountinoCore\Modules\AjaxSearch;

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

class Module
{

	public function __construct()
	{
		add_action("wp_ajax_nopriv_ajax_search", [$this, "autoCompleteSearch"]);
		add_action("wp_ajax_ajax_search", [$this, "autoCompleteSearch"]);
	}

	public function autoCompleteSearch()
	{
		$returnPosts = [];
		$searchText = $_POST['s'];
		$queryArgs = [
			's' => $searchText,
			'posts_per_page' => 8,
			'post_type' => ['post', 'product']
		];
		$query = new \WP_Query($queryArgs);

		foreach ($query->posts as $post) {
			$returnPosts[] = [
				'title' => $post->post_title,
				'url' => get_permalink($post->ID),
			];
		}

		wp_reset_postdata();

		echo json_encode($returnPosts);

		wp_die();
	}



	public static function is_active()
	{
		return false;
	}

	public static function get_experimental_data()
	{
		return null;
	}
}


new Module();
