<?php

namespace AccountinoCore\Widgets;


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Css_Filter;

if (! defined('ABSPATH')) exit; // Exit if accessed directly

class Woocommerce_Products extends Widget_Base
{

    public function get_name()
    {
        return 'woocommerce_products_widget';
    }

    public function get_title()
    {
        return esc_html__('محصولات', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-products';
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    public function register_controls()
    {
        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوا', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'product_categories',
            [
                'label' => esc_html__('دسته بندی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_categories(),
            ]
        );

        $this->add_control(
            'include_products',
            [
                'label' => esc_html__('لیست مشخص از محصولات', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => $this->get_products_list(), // Define below
            ]
        );

        $this->add_control(
            'exclude_products',
            [
                'label' => esc_html__('محصولاتی که نمایش داده نشود', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => $this->get_products_list(),
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => esc_html__('تعداد محصولات', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::NUMBER,
                'default' => 4,
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('ترتیب نمایش', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'ASC' => __('صعودی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'DESC' => __('نزولی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                ],
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => esc_html__('تعداد ستون ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '2' => '2 ستون',
                    '3' => '3 ستون',
                    '4' => '4 ستون',
                ]
            ]
        );

        $this->add_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین کارت ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 20,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-products-grid' => 'gap: 0 {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('product_style_tabs');

        // Normal Tab
        $this->start_controls_tab('product_style_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ متن نام محصول', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box .product-box-main__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .product-box .product-box-main__title',
            ]
        );

        $this->add_control(
            'short_description_color',
            [
                'label' => esc_html__('رنگ متن توضیحات کوتاه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box .product-box-top__excerpt' => 'color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'short_description_typography',
                'selector' => '{{WRAPPER}} .product-box .product-box-top__excerpt',
            ]
        );

        $this->add_control(
            'price_color',
            [
                'label' => esc_html__('رنگ متن قیمت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box .price' => 'color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_typography',
                'selector' => '{{WRAPPER}} .product-box .price',
            ]
        );

        $this->add_control(
            'price_unit_color',
            [
                'label' => esc_html__('رنگ متن واحد قیمت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box .price .woocommerce-Price-currencySymbol' => 'color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_unit_typography',
                'selector' => '{{WRAPPER}} .product-box .price .woocommerce-Price-currencySymbol'
            ]
        );


        $this->add_control(
            'image_background',
            [
                'label' => esc_html__('پس زمینه عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box .product-box-top__left' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .product-box .product-box-top__right' => 'background-color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'box_background',
            [
                'label' => esc_html__('پس زمینه باکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box .product-box-main' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'striped_top_section',
            [
                'label' => esc_html__('هاشور پس زمینه عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('Yes', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('No', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'striped_top_section_color',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'striped_top_section' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-box .product-box-top__left' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                    '{{WRAPPER}} .product-box .product-box-top__right' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
            ]
        );

        $this->end_controls_tab();

        // Hover Tab
        $this->start_controls_tab('product_style_hover', [
            'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__('رنگ متن نام محصول', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box:hover .product-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'short_description_color_hover',
            [
                'label' => esc_html__('رنگ متن توضیحات کوتاه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box:hover .product-box-top__excerpt' => 'color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'price_color_hover',
            [
                'label' => esc_html__('رنگ متن قیمت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box:hover .price' => 'color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'price_unit_color_hover',
            [
                'label' => esc_html__('رنگ متن واحد قیمت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box:hover .price .woocommerce-Price-currencySymbol' => 'color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'box_background_hover',
            [
                'label' => esc_html__('پس زمینه باکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box:hover .product-box-main' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'image_background_hover',
            [
                'label' => esc_html__('پس زمینه عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box:hover .product-box-top__left' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .product-box:hover .product-box-top__right' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'striped_top_section_color_hover',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'striped_top_section' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-box:hover .product-box-top__left' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                    '{{WRAPPER}} .product-box:hover .product-box-top__right' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                    '{{WRAPPER}} .product-box:hover .product-box__button' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        // Button Style
        $this->start_controls_section(
            'button_style_section',
            [
                'label' => esc_html__('استایل دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('button_style_tabs');

        // Normal Tab
        $this->start_controls_tab('button_style_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'button_background_color',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box .product-box__button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => esc_html__('رنگ دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box .product-box__button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .product-box .product-box__button'
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .product-box .product-box__button'
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .product-box .product-box__button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .product-box .product-box__button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_tab();

        // Button Hover Tab
        $this->start_controls_tab('button_style_hover', [
            'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'button_background_color_hover',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box:hover .product-box__button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_text_color_hover',
            [
                'label' => esc_html__('رنگ دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-box:hover .product-box__button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border_hover',
                'selector' => '{{WRAPPER}} .product-box:hover .product-box__button'
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        // Image Style
        $this->start_controls_section(
            'image_style_section',
            [
                'label' => esc_html__('استایل عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('image_style_tabs');

        // Normal Tab
        $this->start_controls_tab('image_style_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'image_css_filters',
                'label' => esc_html__('فیلتر های CSS عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .product-box .product-box-top__image img',
            ]
        );


        $this->end_controls_tab();

        // Image Hover Tab
        $this->start_controls_tab('image_style_hover', [
            'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'image_css_filters_hover',
                'label' => esc_html__('فیلتر های CSS عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .product-box:hover .product-box-top__image img',
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $args = [
            'post_type' => 'product',
            'posts_per_page' => $settings['posts_per_page'],
        ];

        $args['order'] = $settings['order'];

        if (!empty($settings['product_categories'])) {
            $args['tax_query'] = [[
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => $settings['product_categories'],
            ]];
        }

        if (!empty($settings['include_products'])) {
            $args['post__in'] = $settings['include_products'];
        }

        if (!empty($settings['exclude_products'])) {
            $args['post__not_in'] = $settings['exclude_products'];
        }

        $loop = new \WP_Query($args);

        if ($loop->have_posts()) {
            echo '<div class="accountino-woo-products-grid columns-' . esc_attr($settings['columns']) . '">';
            while ($loop->have_posts()) {
                $loop->the_post();
                global $product;

                $region = get_post_meta($product->get_id(), '_product_region', true);
                $region = (!empty($region) ? esc_html__(mb_substr(strip_tags($region), 0, 15)) : null);

                $price = $product->get_price_html();
                if ($product->is_type('variable')) {
                    $prices = $product->get_variation_prices();
                    if (!empty($prices['price'])) {
                        $min_price = min($prices['price']);

                        $price = wc_price($min_price);
                    }
                }

                echo "<div class='product-box'>
                    <a href='" . get_the_permalink() . "'>
                        <div class='product-box-top'>
                            <div class='product-box-top__shapes'>
                                <span class='product-box-top__right'></span>
                                <span class='product-box-top__left'>
                                    <span class='product-box-top__excerpt'>
                                        {$region}
                                    </span>
                                </span>
                            </div>
                            <div class='product-box-top__image'>
                                " . woocommerce_get_product_thumbnail() . "
                            </div>
                            <div class='product-box-top__circle'>
                            </div>
                        </div>
                        <div class='product-box-main'>
                            <div class='product-box-main__details'>
                                <div class='product-box-main__title'>
                                    " . get_the_title() . "
                                </div>
                                <div class='product-box-main__price'>
                                    <span class='product-box-main__price_title'>شروع قیمت از</span>
                                    <span class='price'>
                                        {$min_price}
                                    </span>
                                </div>
                            </div>
                            <span class='product-box__button'>
                                مشاهده و خرید
                            </span>
                        </div>
                    </a>
                </div>";
            }
            echo '</div>';
        } else {
            echo '<p>' . esc_html__('No products found.', ACCOUNTINO_CORE_WIDGETS_PANEL) . '</p>';
        }

        wp_reset_postdata();
    }

    private function get_product_categories()
    {
        $terms = get_terms(['taxonomy' => 'product_cat', 'hide_empty' => false]);
        $options = [];
        foreach ($terms as $term) {
            $options[$term->slug] = $term->name;
        }
        return $options;
    }

    private function get_products_list()
    {
        if (!class_exists('WooCommerce')) return;

        $products = wc_get_products([
            'limit' => -1,
            'return' => 'ids',
        ]);
        $options = [];
        foreach ($products as $product_id) {
            $options[$product_id] = get_the_title($product_id);
        }
        return $options;
    }
}
