<?php

namespace AccountinoCore\Widgets;


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Icons_Manager;
use Elementor\Repeater;

if (! defined('ABSPATH')) exit; // Exit if accessed directly

class Woocommerce_Filter extends Widget_Base
{

    public function get_name()
    {
        return 'woocommerce_filters_widget';
    }

    public function get_title()
    {
        return esc_html__('فیلترهای ووکامرس', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-filter';
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    public function get_keywords()
    {
        return ['filter', 'woocommerce', 'فیلتر', ACCOUNTINO_CORE_WIDGETS_PANEL];
    }

    public function get_style_depends()
    {
        return ['accountino-nouislider-style'];
    }

    public function get_script_depends()
    {
        return ['accountino-nouislider-script'];
    }

    public function register_controls()
    {
        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوا', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control('title', [
            'label' => esc_html__('عنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('عنوان فیلتر', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $repeater->add_control('subtitle', [
            'label' => esc_html__('زیرعنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('زیرعنوان فیلتر', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $repeater->add_control('icon', [
            'label' => esc_html__('آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::ICONS,
        ]);

        $repeater->add_control('filter_type', [
            'label' => esc_html__('نوع فیلتر', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::SELECT,
            'options' => [
                'categories' => esc_html__('دسته بندی ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'duration' => esc_html__('مدت زمان اشتراک', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'price' => esc_html__('محدوده قیمت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'activation' => esc_html__('نحوه فعالسازی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'language' => esc_html__('زبان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ],
            'default' => 'categories',
        ]);

        $this->add_control('filters', [
            'label' => esc_html__('فیلترها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'title_field' => '{{{ title }}}',
        ]);

        $this->end_controls_section();


        // Style Section
        $this->start_controls_section('section_style', [
            'label' => esc_html__('استایل فیلتر ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->start_controls_tabs('section_style_tabs');

        foreach (
            [
                'normal' => '',
                'hover' => ':hover',
                'active' => '.active'
            ] as $state => $pseudo
        ) {
            $this->start_controls_tab("tab_{$state}", [
                'label' => ucfirst($state),
            ]);

            $selector = "{{WRAPPER}} .accountino-woo-filters .accountino-woo-filters-item{$pseudo}";

            $this->add_control(
                "box_background_{$state}",
                [
                    'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        $selector => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                "box_padding_{$state}",
                [
                    'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => "box_border_{$state}",
                    'selector' => $selector,
                ]
            );

            $this->add_control(
                "radius_{$state}",
                [
                    'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors' => [
                        $selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                "title_color_{$state}",
                [
                    'label' => esc_html__('رنگ متن عنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        "$selector .accountino-woo-filter-title" => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => "title_typo_{$state}",
                    'selector' => "$selector .accountino-woo-filter-title",
                ]
            );

            $this->add_control(
                "subtitle_color_{$state}",
                [
                    'label' => esc_html__('رنگ متن زیرعنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        "$selector .accountino-woo-filter-subtitle" => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => "subtitle_typo_{$state}",
                    'selector' => "$selector .accountino-woo-filter-subtitle",
                ]
            );

            $this->add_control(
                "icon_color_{$state}",
                [
                    'label' => esc_html__('رنگ آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        "$selector .accountino-woo-filter-icon svg" => 'fill: {{VALUE}};',
                        "$selector .accountino-woo-filter-icon g" => 'fill: {{VALUE}};',
                        "$selector .accountino-woo-filter-icon path" => 'fill: {{VALUE}};',
                    ],
                    'separator' => 'before'
                ]
            );

            $this->add_control(
                "icon_size_{$state}",
                [
                    'label' => esc_html__('سایز آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 25,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        "$selector .accountino-woo-filter-icon .icon" => 'width: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                "arrow_icon_color_{$state}",
                [
                    'label' => esc_html__('رنگ آیکن کشویی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        "$selector .accountino-woo-filter-arrow" => 'color: {{VALUE}};',
                    ],
                    'separator' => 'before'
                ]
            );

            $this->add_control(
                "arrow_icon_size_{$state}",
                [
                    'label' => esc_html__('سایز آیکن کشویی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 25,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        "$selector .accountino-woo-filter-arrow" => 'font-size: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();
        }

        $this->end_controls_tabs();

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section('content_style', [
            'label' => esc_html__('استایل محتوای فیلترها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control(
            'content_background_color',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-filters-item-content' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-filters-item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_border',
                'selector' => '{{WRAPPER}} .accountino-woo-filters-item-content'
            ]
        );

        $this->add_control(
            'content_border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-filters-item-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display(); ?>
        <form method="GET" action="<?php echo esc_url(get_permalink(wc_get_page_id('shop'))); ?>" class="accountino-woo-filters-form">
            <div class="accountino-woo-filters">
                <?php
                foreach ($settings['filters'] as $item) { ?>
                    <div class="accountino-woo-filters-item-wrapper">
                        <div class="accountino-woo-filters-item">
                            <?php if (!empty($item['icon']['value'])) {
                                echo '<div class="accountino-woo-filter-icon">';
                                Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => 'icon']);
                                echo '</div>';
                            } ?>
                            <div class="accountino-woo-filter-content">
                                <h3 class="accountino-woo-filter-title"><?= esc_html($item['title']); ?></h3>
                                <div class="accountino-woo-filter-subtitle"><?= esc_html($item['subtitle']); ?></div>
                            </div>
                            <div class="accountino-woo-filter-arrow"><i class="eicon-chevron-right"></i></div>
                        </div>
                        <div class="accountino-woo-filters-item-content">
                            <?php
                            include(ACCOUNTINO_CORE_PATH . "elementor_widgets/woocommerce-filter/views/filter-{$item['filter_type']}.php")
                            ?>
                        </div>
                    </div>
                <?php
                } ?>
            </div>
        </form>
        <script>
            jQuery('.accountino-woo-filters-item-content ul li input[type="checkbox"]').change(function() {
                jQuery(this).closest('form').submit();
            })

            jQuery(document).ready(function() {
                jQuery('.accountino-woo-filters-item-content').each(function() {
                    let hasData = false;

                    if (jQuery(this).find('input[type="checkbox"]:checked').length)
                        hasData = true;

                    if (jQuery(this).find('.accountino-price-values').length)
                        hasData = true;

                    if (!hasData) {
                        jQuery(this).slideUp();
                    } else {
                        openFilterContent(jQuery(this).prev());
                    }
                });

                jQuery('.accountino-woo-filters-item').click(function() {
                    if (jQuery(this).next().is(':visible')) {
                        closeFilterContent(jQuery(this));
                    } else {
                        openFilterContent(jQuery(this));
                    }
                })
            })

            function closeFilterContent(box) {
                box.next().slideUp();
                box.removeClass('active');
                box.find('.accountino-woo-filter-arrow i').removeClass('eicon-chevron-left');
            }

            function openFilterContent(box) {
                box.next().slideDown();
                box.addClass('active');
                box.find('.accountino-woo-filter-arrow i').addClass('eicon-chevron-left');
            }
        </script>
<?php
    }
}
