<?php
$min_price = isset($_GET['min_price']) ? floatval($_GET['min_price']) : 500000;
$max_price = isset($_GET['max_price']) ? floatval($_GET['max_price']) : 2000000;
?>

<div class="accountino-price-values accountino-form">
    <div class="price-row">
        از
        <input type="text" name="min_price" id="accountino_min_price" value="<?php echo $min_price; ?>" readonly>
        تومان
    </div>
    <div class="price-row">
        تا
        <input type="text" name="max_price" id="accountino_max_price" value="<?php echo $max_price; ?>" readonly>
        تومان
    </div>
    <div id="accountino-price-slider"></div>
    <div class="price-row">
        <span id="accountino_min_price_label"><?php echo $min_price; ?></span>
        <span id="accountino_max_price_label"><?php echo $max_price; ?></span>
    </div>
</div>


<script>
    document.addEventListener('DOMContentLoaded', function() {
        const slider = document.getElementById('accountino-price-slider');
        const inputMin = document.getElementById('accountino_min_price');
        const inputMax = document.getElementById('accountino_max_price');
        const inputMinLabel = document.getElementById('accountino_min_price_label');
        const inputMaxLabel = document.getElementById('accountino_max_price_label');

        if (typeof noUiSlider !== 'undefined' && slider) {
            noUiSlider.create(slider, {
                start: [parseInt(inputMin.value.replace(/,/g, ""), 10), parseInt(inputMax.value.replace(/,/g, ""), 10)],
                connect: true,
                step: 10000,
                range: {
                    'min': 1000,
                    'max': 5000000
                },
                format: {
                    to: value => Math.round(value),
                    from: value => Number(value)
                }
            });

            slider.noUiSlider.on('update', function(values) {
                minFormatted = values[0].toLocaleString();
                maxFormatted = values[1].toLocaleString();
                inputMin.value = minFormatted;
                inputMax.value = maxFormatted;
                inputMinLabel.innerText = minFormatted;
                inputMaxLabel.innerText = maxFormatted;
            });

            slider.noUiSlider.on('end', function(values) {
                jQuery('.accountino-woo-filters-form').submit();
            });

            jQuery('.accountino-woo-filters-form').submit(function() {
                inputMin.value = parseInt(inputMin.value.replace(/,/g, ""), 10);
                inputMax.value = parseInt(inputMax.value.replace(/,/g, ""), 10);
            });
        }
    });
</script>