<?php

namespace AccountinoCore\Widgets;


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if (! defined('ABSPATH')) exit; // Exit if accessed directly

class Woocommerce_Custom_Product extends Widget_Base
{

    public function get_name()
    {
        return 'woocommerce_custom_product_widget';
    }

    public function get_title()
    {
        return esc_html__('محصول پیشرفته', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-products';
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    public function get_script_depends()
    {
        return ['accountino-custom-product-script', 'wc-add-to-cart-variation', 'wc-single-product', 'add-to-cart', 'jquery-blockui', 'wc-add-to-cart', 'wc-cart-fragments'];
    }

    public function get_styledepends()
    {
        return ['woocommerce_frontend_styles'];
    }

    public function register_controls()
    {
        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوا', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'selected_product',
            [
                'label' => esc_html__('انتخاب محصول', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => $this->get_products(),
            ]
        );

        $this->end_controls_section();

        // Style Section for Variable
        $this->start_controls_section(
            'style_section_variable',
            [
                'label' => esc_html__('استایل', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('variable_style_tabs');

        $this->start_controls_tab(
            'variable_normal_tab',
            [
                'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'variable_name_color',
            [
                'label' => esc_html__('رنگ متن آیتم ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-variations-item .accountino-custom-variations-item__title' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .accountino-custom-product-price-title_box__persian' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'variable_name_typography',
                'selector' => '{{WRAPPER}} .accountino-custom-variations-item .accountino-custom-variations-item__title',
            ]
        );

        $this->add_control(
            'variable_description_color',
            [
                'label' => esc_html__('رنگ توضیحات آیتم ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-variations-item .accountino-custom-variations-item__description' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .accountino-custom-product-price-title_box__english' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'variable_description_typography',
                'selector' => '{{WRAPPER}} .accountino-custom-variations-item .accountino-custom-variations-item__description',
            ]
        );

        $this->add_control(
            'box_background',
            [
                'label' => esc_html__('پس زمینه آیتم ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-variations-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'variable_border',
                'selector' => '{{WRAPPER}} .accountino-custom-variations-item',
            ]
        );

        $this->add_control(
            'items_border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-variations-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'items_padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-variations-item>label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'variable_hover_tab',
            [
                'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'variable_name_color_hover',
            [
                'label' => esc_html__('رنگ متن آیتم ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-variations-item:hover .accountino-custom-variations-item__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'variable_description_color_hover',
            [
                'label' => esc_html__('رنگ توضیحات آیتم ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-variations-item:hover .accountino-custom-variations-item__description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'box_background_hover',
            [
                'label' => esc_html__('پس زمینه آیتم ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-variations-item:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'striped_top_section',
            [
                'label' => esc_html__('هاشور پس زمینه عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('Yes', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('No', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'striped_top_section_color',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'striped_top_section' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-variations-item:hover' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'variable_border_hover',
                'selector' => '{{WRAPPER}} .accountino-custom-variations-item:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();


        // Buttons Style

        // Button Style
        $this->start_controls_section(
            'button_style_section',
            [
                'label' => esc_html__('استایل دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('button_style_tabs');

        // Normal Tab
        $this->start_controls_tab('button_style_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'button_background_color',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-product-price__add_to_card button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => esc_html__('رنگ دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-product-price__add_to_card button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .accountino-custom-product-price__add_to_card button'
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .accountino-custom-product-price__add_to_card button'
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-product-price__add_to_card button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-product-price__add_to_card button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'striped_bg',
            [
                'label' => esc_html__('هاشور پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('Yes', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('No', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'striped_bg_color',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'striped_bg' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-product-price__add_to_card button' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
            ]
        );

        $this->end_controls_tab();

        // Button Hover Tab
        $this->start_controls_tab('button_style_hover', [
            'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'button_background_color_hover',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-product-price__add_to_card button:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_text_color_hover',
            [
                'label' => esc_html__('رنگ دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-product-price__add_to_card button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border_hover',
                'selector' => '{{WRAPPER}} .accountino-custom-product-price__add_to_card button:hover'
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    private function get_products()
    {
        $args = [
            'post_type' => 'product',
            'posts_per_page' => -1,
        ];

        $products = get_posts($args);
        $options = [];
        foreach ($products as $product) {
            $options[$product->ID] = $product->post_title;
        }
        return $options;
    }

    public function render()
    {


        $settings = $this->get_settings_for_display();
        $product_id = $settings['selected_product'];

        if (!$product_id || !function_exists('wc_get_product')) return;

        $product = wc_get_product($product_id);

        if (!$product || !$product->is_type('variable')) {
            echo '<div>' . esc_html__('Invalid product or not variable.', ACCOUNTINO_CORE_WIDGETS_PANEL) . '</div>';
            return;
        }


        $variations = $product->get_available_variations();
        $attributes = $product->get_variation_attributes();
        $default_attributes = $product->get_default_attributes();

        echo '<div class="acountino-variable-product" data-product_id="' . esc_attr($product_id) . '">';

        $form_data = wc_esc_json(wp_json_encode($variations));

        echo '<form class="variations_form cart accountino-custom-product-form" method="post" enctype="multipart/form-data"
            data-product_id="' . esc_attr($product_id) . '"
            data-product_variations=\'' . $form_data . '\'>';

        foreach ($attributes as $attribute_name => $options) {
            $key = esc_attr(sanitize_title($attribute_name));
            $name = "attribute_{$key}"; ?>
            <div class="accountino-custom-product-variations">
                <table class="variations" style="display: none;">
                    <tbody>
                        <tr>
                            <td class="value">
                                <?php
                                echo '<select name="' . $name . '">';
                                echo '<option value=""></option>';
                                foreach ($options as $option) {
                                    $selected = ($default_attributes[$key] ?? '') === $option ? 'selected' : '';
                                    echo '<option value="' . esc_attr($option) . '" ' . $selected . '>' . esc_html__($option) . '</option>';
                                }
                                echo '</select>';
                                ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <div class="accountino-custom-product-variations-items">
                    <?php
                    foreach ($options as $option) {
                        $variationId = null;
                        foreach ($variations as $variation) {
                            $attrName = $variation['attributes'][$name];
                            if (isset($attrName) && trim($attrName) == trim(esc_html__($option))) {
                                $variationId = $variation['variation_id'];
                                break;
                            }
                        }
                        if (!empty($variationId)) {
                            $variationData = new \WC_Product_Variation($variationId);
                            $variationDescription = $variationData->get_description();
                        } else {
                            $variationDescription = null;
                        }

                        $checked = ($default_attributes[$key] ?? '') === $option ? 'checked' : '';
                        echo '<div class="accountino-custom-variations-item">
                                    <label>
                                        <label>
                                            <input type="radio" onclick="setVariation(this.value, this.name)" name="' . $name . '!!!preview" value="' . esc_attr($option) . '" ' . $checked . '> 
                                            <span class="accountino-custom-variations-item__select">
                                                <i class="fas fa-check"></i>
                                            </span>
                                        </label>
                                        <span class="accountino-custom-variations-item__titles">
                                            <span class="accountino-custom-variations-item__title">' . esc_html__($option) . ' </span>
                                            <span class="accountino-custom-variations-item__description">' . $variationDescription . ' </span>
                                        </span>
                                    </label>
                                </div>';
                    }
                    ?>
                </div>
            </div>
            <div class="accountino-custom-product-price">
                <div class="accountino-custom-product-price-title">
                    <span class="accountino-custom-product-price__icon">
                        <svg width="14" height="14" viewBox="0 0 14 14" fill="#fff" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9.30501 4.61033C8.37646 4.61033 7.46876 4.88567 6.6967 5.40155C5.92464 5.91742 5.32289 6.65066 4.96755 7.50853C4.61221 8.3664 4.51923 9.31037 4.70039 10.2211C4.88154 11.1318 5.32868 11.9683 5.98526 12.6249C6.64185 13.2815 7.47839 13.7286 8.38909 13.9098C9.2998 14.0909 10.2438 13.998 11.1016 13.6426C11.9595 13.2873 12.6927 12.6855 13.2086 11.9135C13.7245 11.1414 13.9998 10.2337 13.9998 9.30516C13.9984 8.06044 13.5034 6.86711 12.6232 5.98696C11.7431 5.10681 10.5497 4.61173 9.30501 4.61033ZM11.0656 9.89202H9.89187V11.0657H8.71816V9.89202H7.54445V8.71831H8.71816V7.5446H9.89187V8.71831H11.0656V9.89202ZM2.76393 8.07864L-0.000152588 0L8.07849 2.76408L4.46464 4.46596L2.76393 8.07864Z" fill="white" />
                        </svg>
                    </span>
                    <div class="accountino-custom-product-price-title_box">
                        <span class="accountino-custom-product-price-title_box__persian">تایید و ثبت سفارش</span>
                        <span class="accountino-custom-product-price-title_box__english">Accept and Ordering</span>
                    </div>
                </div>
                <div class="accountino-custom-product-price-left">
                    <div class="accountino-custom-product-price-left__count">
                        <label for="quantity"><?= esc_html__('تعداد', ACCOUNTINO_CORE_WIDGETS_PANEL); ?></label>
                        <p class="form-row form-row-wide">
                            <span class="quantity-wrapper">
                                <button type="button" class="qty-plus">+</button>
                                <input type="number" id="quantity" readonly class="input-text qty text" step="1" min="1" name="quantity" value="1" title="Qty" size="4" inputmode="numeric">
                                <button type="button" class="qty-minus">-</button>
                            </span>
                        </p>
                    </div>
                    <div class="accountino-custom-product-price-left-order">
                        <span class="accountino-custom-product-price-left-order__title">مبلغ قابل پرداخت</span>
                        <span class="accountino-custom-product-price-left-order__price" id="price-box">
                            <span class='price'></span>
                        </span>
                    </div>
                </div>
                <div class="accountino-custom-product-price__add_to_card">
                    <button type="submit" class="single_add_to_cart_button button alt"><?= esc_html__('افزودن به سبد خرید', ACCOUNTINO_CORE_WIDGETS_PANEL); ?></button>
                    <input type="hidden" name="add-to-cart" value="<?= esc_attr($product_id); ?>" />
                    <input type="hidden" name="product_id" value="<?= esc_attr($product_id); ?>" />
                    <input type="hidden" name="variation_id" class="variation_id" value="0" />
                </div>
            </div>
            </form>
            </div>
<?php
        }
    }
}
