<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Css_Filter;
use Accountino_Woocommerce;

if (! defined('ABSPATH')) exit; // Exit if accessed directly

class Woocommerce_Categories extends Widget_Base
{

    public function get_name()
    {
        return 'woocommerce_categories_widget';
    }

    public function get_title()
    {
        return esc_html__('دسته بندی محصولات', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-product-categories';
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    public function register_controls()
    {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوا', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => esc_html__('تعداد دسته ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::NUMBER,
                'default' => 5,
            ]
        );


        $this->add_control(
            'category_name_tag',
            [
                'label' => esc_html__('تگ HTML نام دسته بندی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h4',
            ]
        );

        $this->add_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین کارت ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 20,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-cat-widget-grid' => 'gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .accountino-woo-cat-widget-grid > .accountino-woo-cat-box' => '--between_gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل دسته بندی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-cat-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-cat-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('box_style_tabs');

        // Normal Tab
        $this->start_controls_tab(
            'box_style_normal',
            [
                'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'label' => esc_html__('حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .accountino-woo-cat-box',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box_background',
                'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .accountino-woo-cat-box',
            ]
        );

        $this->add_control(
            'category_text_color',
            [
                'label' => esc_html__('رنگ متن نام دسته بندی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-cat-box .accountino-woo-cat-box__text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'category_name_typography',
                'selector' => '{{WRAPPER}} .accountino-woo-cat-box .accountino-woo-cat-box__text',
            ]
        );


        $this->add_control(
            'category_type_text_color',
            [
                'label' => esc_html__('رنگ متن نوع دسته بندی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-cat-box .accountino-woo-cat-box__type' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'category_type_typography',
                'selector' => '{{WRAPPER}} .accountino-woo-cat-box .accountino-woo-cat-box__type',
            ]
        );


        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'thumbnail_css_filters',
                'label' => esc_html__('فیلتر های CSS عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .accountino-woo-cat-box img',
            ]
        );

        $this->end_controls_tab();

        // Hover Tab
        $this->start_controls_tab(
            'box_style_hover',
            [
                'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border_hover',
                'label' => esc_html__('حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .accountino-woo-cat-box:hover',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box_background_hover',
                'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .accountino-woo-cat-box:hover',
            ]
        );

        $this->add_control(
            'category_text_color_hover',
            [
                'label' => esc_html__('رنگ متن نام دسته بندی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-cat-box:hover .accountino-woo-cat-box__text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'category_type_color_hover',
            [
                'label' => esc_html__('رنگ متن نوع دسته بندی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-cat-box:hover .accountino-woo-cat-box__type' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        // Stripped Border Option
        $this->add_control(
            'stripped_bg_approve',
            [
                'label' => esc_html__('پس زمینه هاشور در شناوری', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('Yes', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('No', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'stripped_bg',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-cat-box:hover' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
                'condition' => [
                    'stripped_bg_approve' => 'yes'
                ]
            ]
        );


        $this->add_control(
            'image_overlay',
            [
                'label' => esc_html__('روکش عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => esc_html__('غیرفعال', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_on' => esc_html__('فعال', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'blend_mode',
            [
                'label' => esc_html__('حالت های ترکیبی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'default' => 'normal',
                'options' => [
                    'normal' => esc_html__('Normal', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'multiply' => esc_html__('Multiply', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'screen' => esc_html__('Screen', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'overlay' => esc_html__('Overlay', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'darken' => esc_html__('Darken', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'lighten' => esc_html__('Lighten', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'color-dodge' => esc_html__('Color Dodge', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'color-burn' => esc_html__('Color Burn', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'hard-light' => esc_html__('Hard Light', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'soft-light' => esc_html__('Soft Light', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'lighten' => esc_html__('Lighten', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'difference' => esc_html__('Difference', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'exclusion' => esc_html__('Exclusion', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'hue' => esc_html__('Hue', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'saturation' => esc_html__('Saturation', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'color' => esc_html__('Color', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'luminosity' => esc_html__('Luminosity', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'plus-darker' => esc_html__('Plus Darker', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'plus-lighter' => esc_html__('Plus Lighter', ACCOUNTINO_CORE_WIDGETS_PANEL),
                ],
                'condition' => [
                    'image_overlay' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-woo-cat-box:hover .accountino-woo-cat-box__overlay' => 'mix-blend-mode: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'overlay_background',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .accountino-woo-cat-box:hover .accountino-woo-cat-box__overlay',
                'fields_options' => [
                    'background' => [
                        'default' => 'classic',
                    ],
                ],
                'condition' => [
                    'image_overlay' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();

        $args = [
            'taxonomy' => 'product_cat',
            'number'   => $settings['number'],
            'hide_empty' => false,
        ];
        $terms = get_terms($args);

        if (!empty($terms) && !is_wp_error($terms)) {
            echo '<div class="accountino-woo-cat-widget-grid">';
            foreach ($terms as $term) {
                $category_type = get_term_meta($term->term_id, 'accountino_product_category_type', true);
                $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);
                $image_url = wp_get_attachment_url($thumbnail_id);
                $term_link = get_term_link($term);
                $category_type = !empty($category_type) ? Accountino_Woocommerce::CUSTOM_PRODUCT_TYPES[$category_type]['plural'] : Accountino_Woocommerce::CUSTOM_PRODUCT_TYPES['محصول']['plural'];
                $categoryName = (!empty($term->name) ? esc_html__(mb_substr(strip_tags($term->name), 0, 17)) . (mb_strlen($term->name) > 17 ? '...' : '') : null);
?>
                <a href="<?= esc_url($term_link); ?>" class="accountino-woo-cat-box">
                    <span class="accountino-woo-cat-box__type"><?= $category_type; ?></span>
                    <<?= $settings['category_name_tag']; ?> class="accountino-woo-cat-box__text"> <?= $categoryName ?></<?= $settings['category_name_tag']; ?>>
                    <?php echo !empty($image_url) ? '<div class="accountino-woo-cat-box__image"><img src="' . esc_url($image_url) . '" alt=""></div>' : null; ?>
                    <span class="accountino-woo-cat-box__overlay"></span>
                </a>
<?php
            }
            echo '</div>';
        } else {
            echo '<p>' . esc_html__('دسته بندی پیدا نشد.', ACCOUNTINO_CORE_WIDGETS_PANEL) . '</p>';
        }
    }
}
