<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Icons_Manager;


if (! defined('ABSPATH')) {
    exit;
}

class Woocommerce_Cart extends Widget_Base
{

    public function get_name()
    {
        return 'woocommerce_cart_widget';
    }

    public function get_title()
    {
        return esc_html__('سبد خرید', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-cart';
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    public function get_keywords()
    {
        return ['cart', 'woocommerce', 'سبد خرید', ACCOUNTINO_CORE_WIDGETS_PANEL];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوا', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'cart_icon',
            [
                'label' => esc_html__('آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::ICONS,
                'skin' => 'inline',
                'label_block' => false,
            ]
        );

        $this->add_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین آیتم ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 20,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [

                    '{{WRAPPER}} .accountino-cart-items' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        // Icon Style
        $this->start_controls_section('section_icon_style', [
            'label' => esc_html__('آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->start_controls_tabs('icon_style_tabs');

        // Normal Tab
        $this->start_controls_tab(
            'icon_style_normal',
            [
                'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'icon_bg',
            [
                'label' => esc_html__('پس زمینه آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [

                    '{{WRAPPER}} .accountino-cart-button' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [

                    '{{WRAPPER}} .accountino-cart-button svg' => 'color: {{VALUE}}; fill: {{VALUE}}',
                    '{{WRAPPER}} .accountino-cart-button svg g' => 'color: {{VALUE}}; fill: {{VALUE}}',
                    '{{WRAPPER}} .accountino-cart-button svg path' => 'color: {{VALUE}}; fill: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'icon_padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .accountino-cart-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'label' => esc_html__('حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .accountino-cart-button',
            ]
        );

        $this->add_control(
            'icon_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .accountino-cart-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_tab();


        // Hover Tab
        $this->start_controls_tab(
            'icon_style_hover',
            [
                'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );


        $this->add_control(
            'icon_bg_hover',
            [
                'label' => esc_html__('پس زمینه آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [

                    '{{WRAPPER}} .accountino-cart-button:hover' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__('رنگ آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [

                    '{{WRAPPER}} .accountino-cart-button:hover svg' => 'color: {{VALUE}}; fill: {{VALUE}}',
                    '{{WRAPPER}} .accountino-cart-button:hover svg g' => 'color: {{VALUE}}; fill: {{VALUE}}',
                    '{{WRAPPER}} .accountino-cart-button:hover svg path' => 'color: {{VALUE}}; fill: {{VALUE}}'
                ]
            ]
        );

        // Stripped Border Option
        $this->add_control(
            'icon_stripped_bg_approve',
            [
                'label' => esc_html__('پس زمینه هاشور در شناوری', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('Yes', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('No', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'icon_stripped_bg',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [

                    '{{WRAPPER}} .accountino-cart-button:hover' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
                'condition' => [
                    'icon_stripped_bg_approve' => 'yes'
                ]
            ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        // Section Box Style
        $this->start_controls_section('section_box_style', [
            'label' => esc_html__('باکس سبد خرید', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control(
            'box_padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .accountino-cart-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'label' => esc_html__('حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .accountino-cart-box',
            ]
        );

        $this->add_control(
            'box_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .accountino-cart-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box_background',
                'selector' => '{{WRAPPER}} .accountino-cart-box',
            ]
        );
        $this->end_controls_section();

        // Item Style
        $this->start_controls_section('item_style', [
            'label' => esc_html__('آیتم های سبد خرید', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control(
            'item_padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .accountino-cart-items-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'label' => esc_html__('حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .accountino-cart-items-item',
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .accountino-cart-items-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'selector' => '{{WRAPPER}} .accountino-cart-items-item',
            ]
        );

        $this->add_control(
            'product_name_color',
            [
                'label' => esc_html__('رنگ نام محصول', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-cii-info__name' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'product_name_typo',
                'selector' => '{{WRAPPER}} .accountino-cii-info__name'
            ]
        );


        $this->add_control(
            'product_price_color',
            [
                'label' => esc_html__('رنگ متن قیمت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-cii-info__price' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'product_price_typo',
                'selector' => '{{WRAPPER}} .accountino-cii-info__price'
            ]
        );

        $this->add_control(
            'product_price_unit_color',
            [
                'label' => esc_html__('رنگ متن واحد قیمت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-cii-info__price .woocommerce-Price-currencySymbol ' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'product_price_unit_typo',
                'selector' => '{{WRAPPER}} .accountino-cii-info__price .woocommerce-Price-currencySymbol'
            ]
        );

        $this->end_controls_section();

        // Delete Button
        $this->start_controls_section('delete_button_style', [
            'label' => esc_html__('دکمه حذف', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->start_controls_tabs('delete_button_style_tabs');

        // Normal Tab
        $this->start_controls_tab(
            'delete_button_style_normal',
            [
                'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'delete_btn_padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .remove-cart-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'delete_btn_border',
                'label' => esc_html__('حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .remove-cart-item',
            ]
        );

        $this->add_control(
            'delete_btn_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .remove-cart-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'delete_btn_bg',
                'selector' => '{{WRAPPER}} .remove-cart-item'
            ]
        );

        $this->add_control(
            'delete_icon_color',
            [
                'label' => esc_html__('رنگ آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .remove-cart-item i' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->end_controls_tab();

        // Hover Tab
        $this->start_controls_tab(
            'delete_button_style_hover',
            [
                'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'delete_btn_bg_hover',
                'selector' => '{{WRAPPER}} .remove-cart-item:hover'
            ]
        );

        $this->add_control(
            'delete_icon_color_hover',
            [
                'label' => esc_html__('رنگ آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .remove-cart-item i:hover' => 'color: {{VALUE}}'
                ]
            ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        // Total Price Section
        $this->start_controls_section('total_price_style', [
            'label' => esc_html__('مبلغ سبد خرید', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control(
            'total_label_color',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-cart-total__label' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'total_label_typo',
                'selector' => '{{WRAPPER}} .accountino-cart-total__label'
            ]
        );

        $this->add_control(
            'total_price_color',
            [
                'label' => esc_html__('رنگ متن قیمت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-cart-total__price' => 'color: {{VALUE}}'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'total_price_typo',
                'selector' => '{{WRAPPER}} .accountino-cart-total__price'
            ]
        );

        $this->add_control(
            'total_price_unit_color',
            [
                'label' => esc_html__('رنگ متن واحد قیمت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-cart-total__price .woocommerce-Price-currencySymbol' => 'color: {{VALUE}}'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'total_price_unit_typo',
                'selector' => '{{WRAPPER}} .accountino-cart-total__price .woocommerce-Price-currencySymbol'
            ]
        );

        $this->end_controls_section();


        // Checkout Button
        $this->start_controls_section('checkout_button_style', [
            'label' => esc_html__('دکمه ثبت سفارش', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);


        $this->start_controls_tabs('checkout_button_style_tabs');

        // Normal Tab
        $this->start_controls_tab(
            'checkout_button_style_normal',
            [
                'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );


        $this->add_control(
            'checkout_bg_color',
            [
                'label' => esc_html__('رنگ پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .checkout-button' => 'background-color: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'checkout_padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .checkout-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'checkout_border',
                'label' => esc_html__('حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .checkout-button',
            ]
        );

        $this->add_control(
            'checkout_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .checkout-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}'
                ]
            ]
        );

        $this->add_control(
            'checkout_text_color',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .checkout-button' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'checkout_typo',
                'selector' => '{{WRAPPER}} .checkout-button'
            ]
        );

        // Stripped Border Option
        $this->add_control(
            'checkout_stripped_bg_approve',
            [
                'label' => esc_html__('پس زمینه هاشور در شناوری', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('Yes', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('No', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'checkout_stripped_bg',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .checkout-button' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
                'condition' => [
                    'checkout_stripped_bg_approve' => 'yes'
                ]
            ]
        );

        $this->end_controls_tab();


        // Hover Tab
        $this->start_controls_tab(
            'checkout_button_style_hover',
            [
                'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'checkout_bg_color_hover',
            [
                'label' => esc_html__('رنگ پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .checkout-button:hover' => 'background-color: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'checkout_text_color+hover',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .checkout-button' => 'color: {{VALUE}}'
                ]
            ]
        );

        // Stripped Border Option

        $this->add_control(
            'checkout_hover_stripped_bg',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .checkout-button:hover' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
                'condition' => [
                    'checkout_stripped_bg_approve' => 'yes'
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $icon = $settings['cart_icon'];
        $cartItemsNo = WC()->cart ? WC()->cart->get_cart_contents_count() : 0;
?>
        <div class="accountino-cart-widget">

            <button type="button" class="accountino-cart-button" onclick="openCartBox(this);" data-before="<?= $cartItemsNo; ?>">
                <?php Icons_Manager::render_icon($icon, ['aria-hidden' => 'true']); ?>
            </button>
            <div class="accountino-cart-box hide">
                <?php include(ACCOUNTINO_CORE_PATH . '/elementor_widgets/woocommerce-cart/woocommerce-cart-details.php'); ?>
            </div>

            <script>
                function updateCartQty(cartKey, qty) {
                    const buttons = jQuery(`.qty-plus[data-cart-item="${cartKey}"], .qty-minus[data-cart-item="${cartKey}"]`);

                    buttons.attr('disabled', true);
                    jQuery.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        method: 'POST',
                        data: {
                            action: 'accountino_update_cart_qty',
                            cart_key: cartKey,
                            quantity: qty,
                        },
                        success: response => {
                            if (response?.data) jQuery('.accountino-cart-button').attr('data-before', response?.data);
                        },
                        complete: () => {
                            buttons.attr('disabled', false);
                        }
                    });
                }

                function changeItemCount(btn, type) {
                    const input = jQuery(btn).parent().find('.qty');
                    const inputValue = parseInt(input.val());
                    const newQuantity = (type == 'plus' ? inputValue + 1 : inputValue - 1);

                    if (newQuantity > 0)
                        updateCartQty(btn?.dataset?.cartItem, newQuantity);

                    input.val(newQuantity);
                }

                function openCartBox(btn) {
                    const toggleBox = jQuery(btn).next();
                    toggleBox.fadeToggle().toggleClass('hide');

                    if (!toggleBox.hasClass('hide')) {
                        jQuery.ajax({
                            url: ajaxUrl,
                            method: 'POST',
                            data: {
                                action: 'accountino_refresh_cart_widget',
                            },
                            success: function(response) {
                                jQuery(btn).closest('.accountino-cart-widget').find('.accountino-cart-box').html(response);
                            }
                        });
                    }
                }
            </script>
        </div>
<?php
    }
}
