<?php
if (!WC()->cart) {
    echo '<p>' . esc_html__('کارت فعال نیست.', ACCOUNTINO_CORE_WIDGETS_PANEL) . '</p>';
} else { ?>
    <div class="accountino-cart-items">
        <?php
        $cartItems = WC()->cart->get_cart();
        if (empty($cartItems)) {
            echo 'سبد خرید شما خالیست!';
        } else {
            foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
                $product   = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
                if (!$product || !$product->exists() || $cart_item['quantity'] == 0) continue;
                $remove_url = wc_get_cart_remove_url($cart_item_key); ?>
                <div class="accountino-cart-items-item">
                    <a href="<?= esc_url($remove_url); ?>" class="remove-cart-item"><i class="fas fa-times"></i></a>
                    <div class="accountino-cii__image"><?= $product->get_image(); ?></div>
                    <div class="accountino-cii-info">
                        <a href="<?= $product->get_permalink(); ?>" class="accountino-cii-info__name"><?= $product->get_name(); ?></a>
                        <div class="accountino-cii-info__price"><?= $product->get_price_html(); ?></div>
                    </div>
                    <div class="quantity-wrapper form-row">
                        <button class="qty-plus" onclick="changeItemCount(this, 'plus')" data-cart-item="<?= esc_attr($cart_item_key); ?>">+</button>
                        <input type="text" class="qty" value="<?= esc_attr($cart_item['quantity']); ?>" readonly />
                        <button class="qty-minus" onclick="changeItemCount(this, 'minus')" data-cart-item="<?= esc_attr($cart_item_key); ?>">-</button>
                    </div>
                </div>
        <?php }
        } ?>
    </div>
    <div class="accountino-cart-total">
        <div class="accountino-cart-total__label"><?= esc_html__('مبلغ قابل پرداخت:', ACCOUNTINO_CORE_WIDGETS_PANEL); ?></div>
        <div class="accountino-cart-total__price"><?= WC()->cart->get_cart_total(); ?></div>
    </div>
    <?php if (!empty($cartItems)) { ?>
        <div class="accountino-cart-checkout">
            <a href="<?= esc_url(wc_get_checkout_url()); ?>" class="button checkout-button"><?= esc_html__('ثبت سفارش و پرداخت', ACCOUNTINO_CORE_WIDGETS_PANEL); ?></a>
        </div>
    <?php } ?>

    <script>
        jQuery('.accountino-cart-button').attr('data-before', '<?= WC()->cart ? WC()->cart->get_cart_contents_count() : 0; ?>')
    </script>
<?php } ?>