<?php

namespace AccountinoCore;

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Main class plugin
 */
class Elementor_Widgets_Manager
{

    public function __construct()
    {
        $widgetList = [
            'site-logo',
            'support',
            'nav-menu',
            'search',
            'button',
            'particle',
            'custom-heading',
            'heading-with-image',
            'woocommerce-categories',
            'woocommerce-products',
            'woocommerce-custom-product',
            'woocommerce-cart',
            'woocommerce-filter',
            'ordering-ways',
            'price-plans',
            'customer-review',
            'blog-list',
            'form',
            'login',
            'signup',
            'custom-list',
            'faq',
            'account',
        ];

        add_action('elementor/widgets/register', function ($widgets_manager) use ($widgetList) {

            foreach ($widgetList as $widgetName) {

                $class_name = str_replace('-', ' ', $widgetName);
                $class_name = str_replace(' ', '_', ucwords($class_name));
                $class_name = '\AccountinoCore\Widgets\\' . $class_name . '';

                require_once(ACCOUNTINO_CORE_PATH . "/elementor_widgets/{$widgetName}/{$widgetName}.php");
                $widgets_manager->register(new $class_name);
            }
        });
    }
}
