<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;


if (! defined('ABSPATH')) {
    exit;
}

class Support extends Widget_Base
{

    public function get_name()
    {
        return 'support_widget';
    }

    public function get_title()
    {
        return __('پشتیبانی', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-headphones';
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    public function get_keywords()
    {
        return ['heading', 'title', 'support', ACCOUNTINO_CORE_WIDGETS_PANEL];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'tel',
            [
                'label' => __('شماره تلفن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __('0216557161', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => __('متن پشتیبانی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::TEXT,
                'default' => __('پشتیبانی 24 ساعته', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'placeholder' => __('متن را وارد کنید', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'support_icon',
            [
                'label' => esc_html__('انتخاب آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'button_icon_align',
            [
                'label' => esc_html__('موقعیت آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'default' => 'right',
                'options' => [
                    'right' => esc_html__('قبل متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'left' => esc_html__('بعد متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                ],
                'condition' => [
                    'support_icon[url]!' => '',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );


        $this->add_control(
            'tel_color',
            [
                'label' => __('رنگ متن شماره تلفن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .accountino-support-widget__text__tel_number' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => __('رنگ متن پشتیبانی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .accountino-support-widget__text__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'box_background',
            [
                'label' => __('رنگ پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-support-widget' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_border_radius',
            [
                'label' => esc_html__('گردی مرزها', 'elementor-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-support-widget' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $telNumber = $settings['tel'];
        $subTitle = $settings['subtitle'];
        $icon = $settings['support_icon'];
        $iconPosition = $settings['button_icon_align'];
        $iconPositionClass = ($iconPosition == 'left' ? 'accountino-support-widget-right-icon' : ''); ?>

        <div class="accountino-support-widget <?= $iconPositionClass; ?>">
            <div class="accountino-support-widget__icon">
                <?php
                if (!empty($settings['support_icon']['url'])) {
                    echo Group_Control_Image_Size::get_attachment_image_html($settings, 'support_icon');
                }
                ?>
            </div>
            <div class="accountino-support-widget__text">
                <span class="accountino-support-widget__text__tel_number"><?= esc_attr($telNumber); ?></span>
                <span class="accountino-support-widget__text__title"><?= esc_attr($subTitle); ?></span>
            </div>
        </div>
<?php
    }
}
