<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Image;
use Elementor\Controls_Manager;

if (! defined('ABSPATH')) {
    exit;
}

class Site_Logo extends Widget_Image
{

    public function get_name()
    {
        return 'site_logo_widget';
    }

    public function get_title()
    {
        return __('لوگو سایت', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-site-logo';
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    protected function _register_controls()
    {
        parent::register_controls();

        $this->update_control(
            'image',
            [
                'dynamic' => [
                    'default' => \AccountinoCore\Plugin::elementor()->dynamic_tags->tag_data_to_tag_text(null, 'site-logo'),
                ],
            ],
            [
                'recursive' => true,
            ]
        );

        $this->update_control(
            'image_size',
            [
                'default' => 'full',
            ]
        );

        $this->update_control(
            'link_to',
            [
                'default' => 'custom',
            ]
        );

        $this->update_control(
            'link',
            [
                'dynamic' => [
                    'default' => \AccountinoCore\Plugin::elementor()->dynamic_tags->tag_data_to_tag_text(null, 'site-url'),
                ],
            ],
            [
                'recursive' => true,
            ]
        );

        $this->remove_control('caption');

        $this->add_control(
            'site_identity_notice',
            [
                'type' => Controls_Manager::RAW_HTML,
                'raw' => sprintf(
                    esc_html__('برای تغییر لوگوی وبسایت، %1$sکلیک کنید%2$s', 'accountino-core'),
                    '<a href="' . esc_url(admin_url('customize.php?autofocus[section]=title_tagline')) . '" target="_blank" >',
                    '</a>'
                ),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
            ],
            [
                'position' => [
                    'of' => 'image',
                    'type' => 'control',
                    'at' => 'before',
                ],
            ]
        );
    }

    protected function get_html_wrapper_class()
    {
        return parent::get_html_wrapper_class() . ' elementor-widget-' . parent::get_name();
    }
}
