<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;
use Elementor\Utils;
use AccountinoCore\Plugin;

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Search extends Widget_Base
{

    public function get_name()
    {
        return 'search-form';
    }

    public function get_title()
    {
        return esc_html__('فرم جستجو', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-site-search';
    }

    public function get_keywords()
    {
        return ['search', 'form'];
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    public function get_style_depends()
    {
        if (Icons_Manager::is_migration_allowed()) {
            return ['elementor-icons-fa-solid'];
        }
        return [];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'search_content',
            [
                'label' => esc_html__('فرم جستجو', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'skin',
            [
                'label' => esc_html__('مدل', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'default' => 'classic',
                'options' => [
                    'classic' => esc_html__('کلاسیک', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'minimal' => esc_html__('مینیمال', ACCOUNTINO_CORE_WIDGETS_PANEL),
                ],
                'prefix_class' => 'elementor-search-form--skin-',
                'render_type' => 'template',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'placeholder',
            [
                'label' => esc_html__('متن پیش فرض', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::TEXT,
                'separator' => 'before',
                'default' => esc_html__('جستجو', ACCOUNTINO_CORE_WIDGETS_PANEL) . '...',
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'heading_button_content',
            [
                'label' => esc_html__('دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'skin' => 'classic',
                ],
            ]
        );

        $this->add_control(
            'button_type',
            [
                'label' => esc_html__('مدل', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'default' => 'icon',
                'options' => [
                    'icon' => esc_html__('آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'text' => esc_html__('رنگ', ACCOUNTINO_CORE_WIDGETS_PANEL),
                ],
                'prefix_class' => 'elementor-search-form--button-type-',
                'render_type' => 'template',
                'condition' => [
                    'skin' => 'classic',
                ],
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__('متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('جسنجو', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'separator' => 'after',
                'condition' => [
                    'button_type' => 'text',
                    'skin' => 'classic',
                ],
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => esc_html__('آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'search',
                'options' => [
                    'search' => [
                        'title' => esc_html__('جستجو', ACCOUNTINO_CORE_WIDGETS_PANEL),
                        'icon' => 'eicon-search',
                    ],
                    'arrow' => [
                        'title' => esc_html__('پیکان', ACCOUNTINO_CORE_WIDGETS_PANEL),
                        'icon' => 'eicon-arrow-left',
                    ],
                ],
                'render_type' => 'template',
                'prefix_class' => 'elementor-search-form--icon-',
                'condition' => [
                    'button_type' => 'icon',
                    'skin' => 'classic',
                ],
            ]
        );

        $this->add_control(
            'size',
            [
                'label' => esc_html__('سایز', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__container' => 'min-height: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .elementor-search-form__submit' => 'min-width: {{SIZE}}{{UNIT}}',
                    'body:not(.rtl) {{WRAPPER}} .elementor-search-form__icon' => 'padding-left: calc({{SIZE}}{{UNIT}} / 3)',
                    'body.rtl {{WRAPPER}} .elementor-search-form__icon' => 'padding-left: calc({{SIZE}}{{UNIT}} / 3)',
                    '{{WRAPPER}} .elementor-search-form__input, {{WRAPPER}}.elementor-search-form--button-type-text .elementor-search-form__submit' => 'padding-right: calc({{SIZE}}{{UNIT}} / 3); padding-left: calc({{SIZE}}{{UNIT}} / 3)',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_input_style',
            [
                'label' => esc_html__('اینپوت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_size_minimal',
            [
                'label' => esc_html__('سایز آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__icon' => '--e-search-form-icon-size-minimal: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'skin' => 'minimal',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'input_typography',
                'selector' => '{{WRAPPER}} input[type="search"].elementor-search-form__input',
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_TEXT,
                ],
            ]
        );

        $this->start_controls_tabs('tabs_input_colors');

        $this->start_controls_tab(
            'tab_input_normal',
            [
                'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'input_text_color',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'global' => [
                    'default' => Global_Colors::COLOR_TEXT,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__input,
					{{WRAPPER}} .elementor-search-form__icon,
					{{WRAPPER}} .elementor-lightbox .dialog-lightbox-close-button,
					{{WRAPPER}} .elementor-lightbox .dialog-lightbox-close-button:hover' => 'color: {{VALUE}}; fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'input_background_color',
            [
                'label' => esc_html__('رنگ پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__container' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'input_border_color',
            [
                'label' => esc_html__('رنگ حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__container' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'input_box_shadow',
                'selector' => '{{WRAPPER}} .elementor-search-form__container',
                'fields_options' => [
                    'box_shadow_type' => [
                        'separator' => 'default',
                    ],
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_input_focus',
            [
                'label' => esc_html__('کلیک', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'input_text_color_focus',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form--focus .elementor-search-form__input,
					{{WRAPPER}} .elementor-search-form--focus .elementor-search-form__icon,
					{{WRAPPER}} .elementor-lightbox .dialog-lightbox-close-button:hover' => 'color: {{VALUE}}; fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'input_background_color_focus',
            [
                'label' => esc_html__('رنگ پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form--focus .elementor-search-form__container' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'input_border_color_focus',
            [
                'label' => esc_html__('رنگ حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form--focus .elementor-search-form__container' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'input_box_shadow_focus',
                'selector' => '{{WRAPPER}} .elementor-search-form--focus .elementor-search-form__container',
                'fields_options' => [
                    'box_shadow_type' => [
                        'separator' => 'default',
                    ],
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'button_border_width',
            [
                'label' => esc_html__('سایز حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__container' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_button_style',
            [
                'label' => esc_html__('دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'skin' => 'classic',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .elementor-search-form__submit',
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_TEXT,
                ],
                'condition' => [
                    'button_type' => 'text',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_button_colors');

        $this->start_controls_tab(
            'tab_button_normal',
            [
                'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__submit' => '--e-search-form-submit-text-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_background_color',
            [
                'label' => esc_html__('رنگ پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'global' => [
                    'default' => Global_Colors::COLOR_SECONDARY,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__submit' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_button_hover',
            [
                'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'button_text_color_hover',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__submit:hover' => '--e-search-form-submit-text-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_background_color_hover',
            [
                'label' => esc_html__('رنگ پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__submit:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('سایز آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__submit' => '--e-search-form-submit-icon-size: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'button_type' => 'icon',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'button_width',
            [
                'label' => esc_html__('عرض', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-search-form__submit' => 'min-width: calc( {{SIZE}} * {{size.SIZE}}{{size.UNIT}} )',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute(
            'input',
            [
                'placeholder' => $settings['placeholder'],
                'class' => 'elementor-search-form__input',
                'type' => 'search',
                'name' => 's',
                'title' => esc_html__('جستجو', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'value' => get_search_query(),
            ]
        );

        // Set the selected icon.
        $icon_class = 'search';

        if ('icon' === $settings['button_type'] && 'arrow' === $settings['icon']) {
            $icon_class = is_rtl() ? 'arrow-left' : 'arrow-left';
        }

        $this->add_render_attribute('icon', [
            'class' => 'fa fa-' . $icon_class,
        ]);

        $icon = [
            'value' => 'fas fa-' . $icon_class,
            'library' => 'fa-solid',
        ];
?>
        <form class="elementor-search-form" role="search" action="<?php // PHPCS - the method home_url is safe.
                                                                    echo home_url(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
                                                                    ?>" method="get">
            <div class="elementor-search-form__container">
                <input <?php $this->print_render_attribute_string('input'); ?> oninput="autoCompleteSearch(this.value)">
                <?php if ('minimal' === $settings['skin']) : ?>
                    <div class="elementor-search-form__icon">
                        <?php $this->render_search_icon($icon, ['aria-hidden' => 'true']); ?>
                        <span class="elementor-screen-only"><?php esc_html_e('Search', ACCOUNTINO_CORE_WIDGETS_PANEL); ?></span>
                    </div>
                <?php endif; ?>
                <?php if ('classic' === $settings['skin']) : ?>
                    <button class="elementor-search-form__submit" type="submit" title="<?php esc_attr_e('Search', ACCOUNTINO_CORE_WIDGETS_PANEL); ?>" aria-label="<?php esc_attr_e('Search', ACCOUNTINO_CORE_WIDGETS_PANEL); ?>">
                        <?php if ('icon' === $settings['button_type']) : ?>
                            <?php $this->render_search_icon($icon, $this->get_render_attributes('icon')); ?>
                            <span class="elementor-screen-only"><?php esc_html_e('Search', ACCOUNTINO_CORE_WIDGETS_PANEL); ?></span>
                        <?php elseif (! empty($settings['button_text'])) : ?>
                            <?php $this->print_unescaped_setting('button_text'); ?>
                        <?php endif; ?>
                    </button>
                <?php endif; ?>
            </div>
            <ul class="search_result"></ul>
        </form>
<?php
    }

    private function render_search_icon($icon, $attributes = [])
    {
        // When the experiment is active and the search icon renders as SVG, it needs additional container for the icon box border.
        if (Plugin::elementor()->experiments->is_feature_active('e_font_icon_svg')) {
            $icon_html = Icons_Manager::render_font_icon($icon, $attributes);

            Utils::print_unescaped_internal_string(sprintf('<div class="e-font-icon-svg-container">%s</div>', $icon_html));
        } else {
            $migration_allowed = Icons_Manager::is_migration_allowed();

            if (! $migration_allowed || ! Icons_Manager::render_icon($icon, ['aria-hidden' => 'true'])) {
                Utils::print_unescaped_internal_string(sprintf('<i %s aria-hidden="true"></i>', esc_attr($this->get_render_attribute_string('icon'))));
            }
        }
    }

    public function get_group_name()
    {
        return 'theme-elements';
    }
}
