<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Group_Control_Background;

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Price_Plans extends Widget_Base
{

    public function get_name()
    {
        return 'price_plans_widget';
    }

    public function get_title()
    {
        return esc_html__('پلن های قیمتی', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-price-table';
    }

    public function get_keywords()
    {
        return ['Price Plan', 'پلن های قیمتی', 'قیمت'];
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    protected function register_controls()
    {
        // Content section
        $this->start_controls_section('section_content', [
            'label' => esc_html__('پلن های قیمتی', ACCOUNTINO_CORE_PANEL_CATEGORY),
        ]);

        $detail_repeater = new Repeater();
        $detail_repeater->add_control('detail_text', [
            'label' => esc_html__('متن آیتم', ACCOUNTINO_CORE_PANEL_CATEGORY),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('جزئیات محصول', ACCOUNTINO_CORE_PANEL_CATEGORY),
        ]);

        $product_repeater = new Repeater();

        $product_repeater->add_control('product_id', [
            'label' => esc_html__('انتخاب محصول', ACCOUNTINO_CORE_PANEL_CATEGORY),
            'type' => Controls_Manager::SELECT2,
            'label_block' => true,
            'multiple' => false,
            'options' => $this->get_products(),
        ]);

        $product_repeater->add_control('card_title', [
            'label' => esc_html__('عنوان کارت', ACCOUNTINO_CORE_PANEL_CATEGORY),
            'type' => Controls_Manager::TEXT,
        ]);
        $product_repeater->add_control('product_details', [
            'label' => esc_html__('جزئیات محصول', ACCOUNTINO_CORE_PANEL_CATEGORY),
            'type' => Controls_Manager::REPEATER,
            'fields' => $detail_repeater->get_controls(),
            'title_field' => '{{{ detail_text }}}',
        ]);

        $this->add_control('products_list', [
            'label' => esc_html__('لیست محصولات', ACCOUNTINO_CORE_PANEL_CATEGORY),
            'type' => Controls_Manager::REPEATER,
            'fields' => $product_repeater->get_controls(),
            'title_field' => '{{{ card_title }}}',
            'prevent_empty' => true,
        ]);


        $this->add_responsive_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین کارت ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 20,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-price-plans' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        // Style Section Box
        $this->start_controls_section('style_section_box', [
            'label' => esc_html__('استایل کارت', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->start_controls_tabs('fields_style_tabs');

        $this->start_controls_tab('field_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'box_background',
            'selector' => '{{WRAPPER}} .accountino-price-plans-items-main',
        ]);

        $this->add_responsive_control('box_padding', [
            'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-price-plans-items-main' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_control(
            'box_border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-price-plans-items-main' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control('card_top_bg', [
            'label' => esc_html__('پس زمینه نام محصول', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-price-plans-items-top' => 'background-color: {{VALUE}};'
            ],
        ]);

        $this->add_control('card_title_color', [
            'label' => esc_html__('رنگ عنوان کارت', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-price-plans-items-top-text__title' => 'color: {{VALUE}};'
            ],
            'separator' => 'before'
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'card_title_typo',
            'selector' => '{{WRAPPER}} .accountino-price-plans-items-top-text__title',
        ]);

        $this->add_control('product_name_color', [
            'label' => esc_html__('رنگ متن نام محصول', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-price-plans-items-top-text__product_name' => 'color: {{VALUE}};'
            ],
            'separator' => 'before'
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'product_name_typo',
            'selector' => '{{WRAPPER}} .accountino-price-plans-items-top-text__product_name',
        ]);

        $this->add_control('price_color', [
            'label' => esc_html__('رنگ متن قیمت', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-price-plans-items-main__price' => 'color: {{VALUE}};'
            ],
            'separator' => 'before'
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'price_typo',
            'selector' => '{{WRAPPER}} .accountino-price-plans-items-main__price',
        ]);

        $this->add_control('price_symbol_color', [
            'label' => esc_html__('رنگ متن واحد قیمت', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-price-plans-items-main__price .woocommerce-Price-currencySymbol' => 'color: {{VALUE}};'
            ],
            'separator' => 'before'
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'price_symbol_typo',
            'selector' => '{{WRAPPER}} .accountino-price-plans-items-main__price .woocommerce-Price-currencySymbol',
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab('field_hover', [
            'label' => esc_html__('شناوری', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_control('card_top_bg_bg', [
            'label' => esc_html__('پس زمینه نام محصول', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-price-plans-items:hover .accountino-price-plans-items-top' => 'background-color: {{VALUE}};'
            ],
        ]);

        $this->add_control('card_title_color_bg', [
            'label' => esc_html__('رنگ عنوان کارت', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-price-plans-items:hover .accountino-price-plans-items-top-text__title' => 'color: {{VALUE}};'
            ],
        ]);

        $this->add_control('product_name_color_bg', [
            'label' => esc_html__('رنگ متن نام محصول', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-price-plans-items:hover .accountino-price-plans-items-top-text__product_name' => 'color: {{VALUE}};'
            ],
        ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        // Product Details Box
        $this->start_controls_section('style_product_details', [
            'label' => esc_html__('جزئیات محصول', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'details_background',
            'selector' => '{{WRAPPER}} .accountino-price-plans-items-main__details',
        ]);

        $this->add_control('details_padding', [
            'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-price-plans-items-main__details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
            ],
        ]);

        $this->add_control(
            'details_border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-price-plans-items-main__details' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control('details_color', [
            'label' => esc_html__('رنگ متن آیتم ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-price-plans-items-main__details li' => 'color: {{VALUE}};'
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'details_typo',
            'selector' => '{{WRAPPER}} .accountino-price-plans-items-main__details li',
        ]);

        $this->add_control('bullet_color', [
            'label' => esc_html__('رنگ دایره', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-price-plans-items-main__details li::before' => 'background-color: {{VALUE}};'
            ],
        ]);

        $this->end_controls_section();

        // Button Section
        // Button Style
        $this->start_controls_section(
            'button_style_section',
            [
                'label' => esc_html__('استایل دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('button_style_tabs');

        // Normal Tab
        $this->start_controls_tab('button_style_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'button_background_color',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-price-plans-items-main__button a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => esc_html__('رنگ دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-price-plans-items-main__button a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .accountino-price-plans-items-main__button a'
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .accountino-price-plans-items-main__button a'
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-price-plans-items-main__button a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-price-plans-items-main__button a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_tab();

        // Button Hover Tab
        $this->start_controls_tab('button_style_hover', [
            'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'button_background_color_hover',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-price-plans-items-main__button a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_text_color_hover',
            [
                'label' => esc_html__('رنگ دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-price-plans-items-main__button a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border_hover',
                'selector' => '{{WRAPPER}} .accountino-price-plans-items-main__button a:hover'
            ]
        );

        $this->add_control(
            'striped_bg',
            [
                'label' => esc_html__('هاشور پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('Yes', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('No', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'striped_bg_color',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'striped_bg' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-price-plans-items-main__button a:hover' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    private function get_products()
    {
        $args = [
            'post_type' => 'product',
            'posts_per_page' => -1,
        ];

        $products = get_posts($args);
        $options = [];
        foreach ($products as $product) {
            $options[$product->ID] = $product->post_title;
        }
        return $options;
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (empty($settings['products_list']))
            return;

        echo "<div class='accountino-price-plans'>";
        foreach ($settings['products_list'] as $productList) {
            if (empty($productList['product_id']))
                continue;
            $product = wc_get_product($productList['product_id']);

            $price = $product->get_price_html();
            if ($product->is_type('variable')) {
                $prices = $product->get_variation_prices();
                if (!empty($prices['price'])) {
                    $min_price = min($prices['price']);

                    $price = wc_price($min_price);
                }
            } ?>
            <div class="accountino-price-plans-items">
                <div class="accountino-price-plans-items-top">
                    <div class="accountino-price-plans-items-top__image">
                        <img src="<?= ACCOUNTINO_CORE_ASSETS_URL; ?>images/medal.png" alt="Medal">
                    </div>
                    <div class="accountino-price-plans-items-top-text">
                        <p class="accountino-price-plans-items-top-text__title"><?= esc_html__($productList['card_title']); ?></p>
                        <h3 class="accountino-price-plans-items-top-text__product_name"><?= esc_html__($product->get_name()); ?></h3>
                    </div>
                    <div class="accountino-price-plans-items__responsive">
                        <div class="accountino-price-plans-items-main__price">
                            <?= $price; ?>
                        </div>
                    </div>
                </div>
                <div class="accountino-price-plans-items-main">
                    <div class="accountino-price-plans-items-main__price">
                        <?= $price; ?>
                    </div>
                    <div class="accountino-price-plans-items-main__details">
                        <ul>
                            <?php
                            if (!empty($productList['product_details'])) {
                                foreach ($productList['product_details'] as $detail)
                                    echo '<li>' . esc_html__($detail['detail_text']) . '</li>';
                            }
                            ?>
                        </ul>
                    </div>
                    <div class="accountino-price-plans-items-main__button">
                        <a href='<?= $product->get_permalink(); ?>'>مشاهده و خرید</a>
                    </div>
                </div>
            </div>

<?php
        }
        echo '</div>';
    }
}
