<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Image;
use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;

if (! defined('ABSPATH')) {
    exit;
}

class Particle extends Widget_Image
{

    public function get_name()
    {
        return 'particle_widget';
    }

    public function get_title()
    {
        return __('ذرات کناره ها', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-image';
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    protected function _register_controls()
    {
        parent::register_controls();

        $this->remove_control('caption');
        $this->remove_control('caption_source');
        $this->remove_control('link_to');

        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__('تنظیمات طرح', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'use_shape',
            [
                'label' => esc_html__('استفاده از شکل', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => esc_html__('نه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_on' => esc_html__('بله', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'site_identity_notice',
            [
                'type' => Controls_Manager::RAW_HTML,
                'raw' => esc_html__('در صورت انتخاب شکل عکس نمایش داده نمیشود', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
                'separator' => 'after'
            ]
        );


        $this->add_responsive_control(
            'full_width',
            [
                'label' => esc_html__('نوع', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => esc_html__('خطی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_on' => esc_html__('عریض', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selectors' => [
                    '{{WRAPPER}} .accountino-particle-widget__image' => 'width: 100%;',
                ]
            ]
        );

        $this->add_responsive_control(
            'position',
            [
                'label' => esc_html__('موقعیت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'default' => 'center',
                'options' => [
                    'center' => esc_html__('وسط', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'right' => esc_html__('راست', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'left' => esc_html__('چپ', ACCOUNTINO_CORE_WIDGETS_PANEL),
                ],
                'frontend_available' => true,
                'selectors' => [
                    '{{WRAPPER}} .accountino-particle-widget' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_horizontal_offset',
            [
                'label' => esc_html__('افست افقی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'default' => [
                    'unit' => '%',
                ],
                'range' => [
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'image_vertical_offset',
            [
                'label' => esc_html__('افست عمودی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'default' => [
                    'unit' => '%',
                ],
                'range' => [
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'image_rotate',
            [
                'label' => esc_html__('چرخش', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['deg'],
                'default' => [
                    'unit' => 'deg',
                ],
                'range' => [
                    'deg' => [
                        'min' => 0,
                        'max' => 360,
                        'step' => 10,
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'image_rotate_x',
            [
                'label' => esc_html__('چرخش X', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['deg'],
                'default' => [
                    'unit' => 'deg',
                ],
                'range' => [
                    'deg' => [
                        'min' => 0,
                        'max' => 360,
                        'step' => 10,
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'image_rotate_y',
            [
                'label' => esc_html__('چرخش Y', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['deg'],
                'default' => [
                    'unit' => 'deg',
                ],
                'range' => [
                    'deg' => [
                        'min' => 0,
                        'max' => 360,
                        'step' => 10,
                    ],
                ],
            ]
        );

        $this->add_control(
            'blend_mode',
            [
                'label' => esc_html__('حالت های ترکیبی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'default' => 'normal',
                'options' => [
                    'normal' => esc_html__('Normal', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'multiply' => esc_html__('Multiply', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'screen' => esc_html__('Screen', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'overlay' => esc_html__('Overlay', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'darken' => esc_html__('Darken', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'lighten' => esc_html__('Lighten', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'color-dodge' => esc_html__('Color Dodge', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'color-burn' => esc_html__('Color Burn', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'hard-light' => esc_html__('Hard Light', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'soft-light' => esc_html__('Soft Light', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'lighten' => esc_html__('Lighten', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'difference' => esc_html__('Difference', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'exclusion' => esc_html__('Exclusion', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'hue' => esc_html__('Hue', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'saturation' => esc_html__('Saturation', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'color' => esc_html__('Color', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'luminosity' => esc_html__('Luminosity', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'plus-darker' => esc_html__('Plus Darker', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'plus-lighter' => esc_html__('Plus Lighter', ACCOUNTINO_CORE_WIDGETS_PANEL),
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-particle-widget__image img' => 'mix-blend-mode: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'overlay',
            [
                'label' => esc_html__('روکش', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => esc_html__('غیرفعال', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_on' => esc_html__('فعال', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'overlay_blend_mode',
            [
                'label' => esc_html__('حالت های ترکیبی روکش', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'default' => 'normal',
                'options' => [
                    'normal' => esc_html__('Normal', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'multiply' => esc_html__('Multiply', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'screen' => esc_html__('Screen', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'overlay' => esc_html__('Overlay', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'darken' => esc_html__('Darken', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'lighten' => esc_html__('Lighten', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'color-dodge' => esc_html__('Color Dodge', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'color-burn' => esc_html__('Color Burn', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'hard-light' => esc_html__('Hard Light', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'soft-light' => esc_html__('Soft Light', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'difference' => esc_html__('Difference', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'exclusion' => esc_html__('Exclusion', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'hue' => esc_html__('Hue', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'saturation' => esc_html__('Saturation', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'color' => esc_html__('Color', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'luminosity' => esc_html__('Luminosity', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'plus-darker' => esc_html__('Plus Darker', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'plus-lighter' => esc_html__('Plus Lighter', ACCOUNTINO_CORE_WIDGETS_PANEL),
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-particle-widget__overlay' => 'mix-blend-mode: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('استایل روکش', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'overlay' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'overlay_background',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .accountino-particle-widget__overlay',
                'fields_options' => [
                    'background' => [
                        'default' => 'classic',
                    ],
                    'condition' => [
                        'overlay' => 'yes'
                    ]
                ],
            ]
        );

        $this->add_control(
            'overlay_opacity',
            [
                'label' => esc_html__('شفافیت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 1,
                ],
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-particle-widget__overlay' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'overlay_blur',
            [
                'label' => esc_html__('محو کردن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 0,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 10,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-particle-widget__overlay' => 'filter: blur({{SIZE}}px);',
                ],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'shape_style',
            [
                'label' => esc_html__('استایل شکل', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'use_shape' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'shape_background',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .accountino-particle-widget__shape',
                'fields_options' => [
                    'background' => [
                        'default' => 'classic',
                    ],
                    'condition' => [
                        'overlay' => 'yes'
                    ]
                ],
            ]
        );

        $this->add_control(
            'shape_striped_bg',
            [
                'label' => esc_html__('هاشور پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('Yes', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('No', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
                'condition' => [
                    'overlay' => 'yes'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'shape_striped_bg_color',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'shape_striped_bg' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-particle-widget__shape' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $isShape = isset($settings['use_shape']) && $settings['use_shape'] == 'yes';

        $allTransforms = $this->getTransformStyles($settings); ?>

        <div class="accountino-particle-widget" id="particle-<?= $this->get_id(); ?>">
            <style>
                <?php
                if (!empty($allTransforms['desktop'])) {
                    echo "
                        #particle-" . $this->get_id() . " .accountino-particle-widget__image img,
                        #particle-" . $this->get_id() . " .accountino-particle-widget__overlay {
                            {$allTransforms['desktop']}
                        }
                    ";
                }
                if (!empty($allTransforms['tablet'])) {
                    echo "@media(max-width: 1024px){
                        #particle-" . $this->get_id() . " .accountino-particle-widget__image img,
                        #particle-" . $this->get_id() . " .accountino-particle-widget__overlay {
                            {$allTransforms['tablet']}
                        }
                    }";
                }
                if (!empty($allTransforms['mobile'])) {
                    echo "@media(max-width: 767px){
                        #particle-" . $this->get_id() . " .accountino-particle-widget__image img,
                        #particle-" . $this->get_id() . " .accountino-particle-widget__overlay {
                            {$allTransforms['mobile']}
                        }
                    }";
                }
                ?>
            </style>
            <div class="accountino-particle-widget__image">
                <?php if ($isShape) { ?>
                    <img class="accountino-particle-widget__shape" />
                <?php } else {
                    Group_Control_Image_Size::print_attachment_image_html($settings);
                }
                ?>
                <div class="accountino-particle-widget__overlay"></div>
            </div>
        </div>
<?php
    }


    private function getTransformStyles($settings)
    {

        $desktop = [];
        $tablet = [];
        $mobile = [];


        if (!empty($settings['image_horizontal_offset']['size']))
            $desktop[] = "translateX({$settings['image_horizontal_offset']['size']}{$settings['image_horizontal_offset']['unit']})";

        if (!empty($settings['image_horizontal_offset_tablet']['size']))
            $tablet[] = "translateX({$settings['image_horizontal_offset_tablet']['size']}{$settings['image_horizontal_offset_tablet']['unit']})";

        if (!empty($settings['image_horizontal_offset_mobile']['size']))
            $mobile[] = "translateX({$settings['image_horizontal_offset_mobile']['size']}{$settings['image_horizontal_offset_mobile']['unit']})";


        // Y
        if (!empty($settings['image_vertical_offset']['size']))
            $desktop[] = "translateY({$settings['image_vertical_offset']['size']}{$settings['image_vertical_offset']['unit']})";

        if (!empty($settings['image_vertical_offset_tablet']['size']))
            $tablet[] = "translateY({$settings['image_vertical_offset_tablet']['size']}{$settings['image_vertical_offset_tablet']['unit']})";

        if (!empty($settings['image_vertical_offset_mobile']['size']))
            $mobile[] = "translateY({$settings['image_vertical_offset_mobile']['size']}{$settings['image_vertical_offset_mobile']['unit']})";


        // Rotate
        if (!empty($settings['image_rotate']['size']))
            $desktop[] = "rotate({$settings['image_rotate']['size']}deg)";

        if (!empty($settings['image_rotate_tablet']['size']))
            $tablet[] = "rotate({$settings['image_rotate_tablet']['size']}deg)";

        if (!empty($settings['image_rotate_mobile']['size']))
            $mobile[] = "rotate({$settings['image_rotate_mobile']['size']}deg)";

        // Rotate X
        if (!empty($settings['image_rotate_x']['size']))
            $desktop[] = "rotateX({$settings['image_rotate_x']['size']}deg)";

        if (!empty($settings['image_rotate_x_tablet']['size']))
            $tablet[] = "rotateX({$settings['image_rotate_x_tablet']['size']}deg)";

        if (!empty($settings['image_rotate_x_mobile']['size']))
            $mobile[] = "rotateX({$settings['image_rotate_x_mobile']['size']}deg)";

        // Rotate Y
        if (!empty($settings['image_rotate_y']['size']))
            $desktop[] = "rotateY({$settings['image_rotate_y']['size']}deg)";

        if (!empty($settings['image_rotate_y_tablet']['size']))
            $tablet[] = "rotateY({$settings['image_rotate_y_tablet']['size']}deg)";

        if (!empty($settings['image_rotate_y_mobile']['size']))
            $mobile[] = "rotateY({$settings['image_rotate_y_mobile']['size']}deg)";


        return [
            'desktop' => !empty($desktop) ? 'transform: ' . implode(' ', $desktop) . ';' : null,
            'tablet' => !empty($tablet) ? 'transform: ' . implode(' ', $tablet) . ';' : null,
            'mobile' => !empty($mobile) ? 'transform: ' . implode(' ', $mobile) . ';' : null,
        ];
    }
}
