<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Ordering_Ways extends Widget_Base
{

    public function get_name()
    {
        return 'ordering_ways_widget';
    }

    public function get_title()
    {
        return esc_html__('مراحل سفارش', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-form-vertical';
    }

    public function get_keywords()
    {
        return ['ordering_ways', 'سفارش', 'مراحل ثبت سفارش'];
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    protected function register_controls()
    {
        // Content Section
        $this->start_controls_section('content_section', [
            'label' => esc_html__('آیتم ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        $repeater = new Repeater();

        $repeater->add_control('title', [
            'label' => esc_html__('عنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('عنوان آیتم', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $repeater->add_control('subtitle', [
            'label' => esc_html__('زیرعنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('زیرعنوان آیتم', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $repeater->add_control('icon', [
            'label' => esc_html__('آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::ICONS,
        ]);

        $repeater->add_control('image', [
            'label' => esc_html__('عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::MEDIA,
        ]);

        $this->add_control('list_items', [
            'label' => esc_html__('لیست مراحل سفارش', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                ['title' => 'مرحله اول'],
            ],
            'title_field' => '{{{ title }}}',
        ]);

        $this->add_responsive_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین کارت ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 20,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-ordering-ways' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section('style_section', [
            'label' => esc_html__('استایل', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-ordering-ways-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->start_controls_tabs('style_tabs');

        $this->start_controls_tab(
            'normal_tab',
            ['label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL)]
        );

        $this->add_control('title_color', [
            'label' => esc_html__('رنگ متن عنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ordering-ways-item-content__title' => 'color: {{VALUE}};'],
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'selector' => '{{WRAPPER}} .ordering-ways-item-content__title',
        ]);

        $this->add_control('subtitle_color', [
            'label' => esc_html__('رنگ متن زیرعنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ordering-ways-item-content__subtitle' => 'color: {{VALUE}};'],
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'subtitle_typography',
            'selector' => '{{WRAPPER}} .ordering-ways-item-content__subtitle',
        ]);

        $this->add_control('icon_color', [
            'label' => esc_html__('رنگ آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ordering-ways-item-content__icon svg' => 'fill: {{VALUE}};',
                '{{WRAPPER}} .ordering-ways-item-content__icon svg path' => 'fill: {{VALUE}};',
                '{{WRAPPER}} .ordering-ways-item-content__icon svg g' => 'fill: {{VALUE}};'
            ],
            'separator' => 'after'
        ]);

        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'item_background',
            'selector' => '{{WRAPPER}} .accountino-ordering-ways-item',
        ]);

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-ordering-ways-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'item_border',
            'selector' => '{{WRAPPER}} .accountino-ordering-ways-item',
        ]);


        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'image_css_filters',
                'label' => esc_html__('فیلتر های CSS عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .accountino-ordering-ways-item .ordering-ways-item__image img',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'hover_tab',
            ['label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL)]
        );

        $this->add_control('title_color_hover', [
            'label' => esc_html__('رنگ متن عنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .accountino-ordering-ways-item:hover .ordering-ways-item-content__title' => 'color: {{VALUE}};'],
        ]);

        $this->add_control('subtitle_color_hover', [
            'label' => esc_html__('رنگ متن زیرعنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .accountino-ordering-ways-item:hover .ordering-ways-item-content__subtitle' => 'color: {{VALUE}};'],
        ]);

        $this->add_control('icon_color_hover', [
            'label' => esc_html__('رنگ آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-ordering-ways-item:hover .ordering-ways-item-content__icon svg' => 'fill: {{VALUE}};',
                '{{WRAPPER}} .accountino-ordering-ways-item:hover .ordering-ways-item-content__icon svg path' => 'fill: {{VALUE}};',
                '{{WRAPPER}} .accountino-ordering-ways-item:hover .ordering-ways-item-content__icon svg g' => 'fill: {{VALUE}};'
            ],
            'separator' => 'after'
        ]);

        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'item_background_hover',
            'selector' => '{{WRAPPER}} .accountino-ordering-ways-item:hover',
        ]);

        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'item_border_hover',
            'selector' => '{{WRAPPER}} .accountino-ordering-ways-item:hover',
        ]);

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'image_css_filters_hover',
                'label' => esc_html__('فیلتر های CSS عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .accountino-ordering-ways-item:hover .ordering-ways-item__image img',
            ]
        );

        $this->add_control(
            'striped_bg',
            [
                'label' => esc_html__('هاشور پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('Yes', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('No', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'striped_bg_color',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'striped_bg' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-ordering-ways-item:hover' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if (empty($settings['list_items'])) return;

        echo '<div class="accountino-ordering-ways">';
        foreach ($settings['list_items'] as $item) {
            echo '<div class="accountino-ordering-ways-item">';

            echo '<div class="ordering-ways-item-content">';

            if (! empty($item['icon']['value'])) {
                echo '<div class="ordering-ways-item-content__icon">';
                Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']);
                echo '</div>';
            }

            echo "<div class='ordering-ways-item-content__titlebox'>";
            if (!empty($item['title'])) {
                echo '<p class="ordering-ways-item-content__title">' . esc_html__($item['title']) . '</p>';
            }

            if (!empty($item['subtitle'])) {
                echo '<p class="ordering-ways-item-content__subtitle">' . esc_html__($item['subtitle']) . '</p>';
            }
            echo "</div>";

            echo '</div>'; // .ordering-ways-item-content

            if (! empty($item['image']['url'])) {
                echo '<div class="ordering-ways-item__image"><img src="' . esc_url($item['image']['url']) . '" alt=""></div>';
            }
            echo '</div>'; // .accountino-ordering-ways-item
        }
        echo '</div>'; // .accountino-ordering-ways
    }
}
