<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Login extends Widget_Base
{

    public function get_name()
    {
        return 'login_widget';
    }

    public function get_title()
    {
        return esc_html__('ورود به حساب کاربری', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-lock-user';
    }

    public function get_keywords()
    {
        return ['login', 'لاگین', 'ورود به حساب کاربری'];
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    protected function register_controls()
    {
        $this->start_controls_section('fields_style', [
            'label' => esc_html__('استایل فیلدها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->start_controls_tabs('fields_style_tabs');

        $this->start_controls_tab('field_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_control(
            'label_text_color',
            [
                'label' => esc_html__('رنگ برچسب', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .field-column label' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'label_typo',
                'selector' => '{{WRAPPER}} .field-column label'
            ]
        );


        $this->add_control(
            'field_text_color',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input, {{WRAPPER}} textarea, {{WRAPPER}} select' => 'color: {{VALUE}}'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'field_background',
            [
                'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input, {{WRAPPER}} textarea, {{WRAPPER}} select' => 'background: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'field_border',
                'selector' => '{{WRAPPER}} input, {{WRAPPER}} textarea, {{WRAPPER}} select'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typo',
                'selector' => '{{WRAPPER}} input, {{WRAPPER}} textarea, {{WRAPPER}} select'
            ]
        );

        $this->add_responsive_control(
            'field_padding',
            [
                'label' => esc_html__('فضای داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [

                    '{{WRAPPER}} input, {{WRAPPER}} textarea, {{WRAPPER}} select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'field_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [

                    '{{WRAPPER}} input, {{WRAPPER}} textarea, {{WRAPPER}} select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('field_hover', [
            'label' => esc_html__('شناوری', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_control(
            'field_hover_bg',
            [
                'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input:hover, {{WRAPPER}} textarea:hover, {{WRAPPER}} select:hover' => 'background: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'field_hover_border_color',
            [
                'label' => esc_html__('رنگ حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input:hover, {{WRAPPER}} textarea:hover, {{WRAPPER}} select:hover' => 'border-color: {{VALUE}}'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('field_focus', [
            'label' => esc_html__('تمرکز', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_control(
            'field_focus_bg',
            [
                'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input:focus, {{WRAPPER}} textarea:focus, {{WRAPPER}} select:focus' => 'background: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'field_focus_border_color',
            [
                'label' => esc_html__('رنگ حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input:focus, {{WRAPPER}} textarea:focus, {{WRAPPER}} select:focus' => 'border-color: {{VALUE}}'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section('submit_button_section', [
            'label' => esc_html__('استایل دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->start_controls_tabs('buttons_style_tabs');

        $this->start_controls_tab('button_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_control(
            'submit_color',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-contact-form button' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'submit_typo',
                'selector' => '{{WRAPPER}} .accountino-contact-form button'
            ]
        );

        $this->add_control(
            'submit_bg',
            [
                'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-contact-form button' => 'background: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} button'
            ]
        );


        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__('فضای داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [

                    '{{WRAPPER}} button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'button_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [

                    '{{WRAPPER}} button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('button_hover', [
            'label' => esc_html__('شناوری', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_control(
            'button_color_hover',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-contact-form button:hover' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'button_bg_hover',
            [
                'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-contact-form button:hover' => 'background: {{VALUE}}'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        if (is_user_logged_in()) { ?>
            <div class="accountino-form-message">
                <div class="accountino-error-message">
                    شما در حال حاضر وارد شده اید!
                    <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>">صفحه داشبورد</a>
                </div>
            </div>
        <?php
            return;
        }
        do_action('accountino_login_display_errors'); ?>
        <form class="accountino-contact-form" method="post">
            <div class="row">
                <div class="field-column column-12">
                    <label>
                        <?= esc_html__('شماره همراه:', ACCOUNTINO_CORE_WIDGETS_PANEL); ?>
                        <input type="text" name="username" value="<?= $_POST['username'] ?? null; ?>" required>
                    </label>
                </div>
                <div class="field-column column-12">
                    <label>
                        <?= esc_html__('رمز عبور:', ACCOUNTINO_CORE_WIDGETS_PANEL); ?>
                        <input type="password" name="password" value="<?= $_POST['password'] ?? null; ?>" required>
                    </label>
                </div>
                <div class="field-column column-12">
                    <label>
                        <button type="submit" class="full-button"><?= esc_html__('ورود به حساب کاربری', ACCOUNTINO_CORE_WIDGETS_PANEL); ?></button>
                    </label>
                </div>
            </div>
            <input type="hidden" name="accountino_login_nonce" value="<?php echo wp_create_nonce('accountino_login'); ?>">
        </form>
<?php
    }
}
