<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Form extends Widget_Base
{

    public function get_name()
    {
        return 'form_widget';
    }

    public function get_title()
    {
        return esc_html__('فرم', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-form-horizontal';
    }

    public function get_keywords()
    {
        return ['فرم', 'تماس با ما'];
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    protected function register_controls()
    {
        $this->start_controls_section('form_fields_section', [
            'label' => esc_html__('تنظیمات فرم', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $repeater = new Repeater();

        $repeater->add_control('field_label', [
            'label' => esc_html__('متن فیلد', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('متن فیلد', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $repeater->add_control('field_type', [
            'label' => esc_html__('نوع فیلد', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::SELECT,
            'default' => 'text',
            'options' => [
                'text' => esc_html__('Text', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'email' => esc_html__('Email', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'textarea' => esc_html__('Textarea', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tel' => esc_html__('Phone', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'number' => esc_html__('Number', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'select' => esc_html__('Select', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'checkbox' => esc_html__('Checkbox', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'radio' => esc_html__('Radio', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'button' => esc_html__('button', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        ]);

        $repeater->add_control('field_name', [
            'label' => esc_html__('نام فیلد', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXT,
            'default' => 'field_id',
        ]);

        $repeater->add_control('field_placeholder', [
            'label' => esc_html__('Placeholder', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXT,
        ]);

        $repeater->add_control('field_required', [
            'label' => esc_html__('الزامی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
        ]);

        $repeater->add_control('field_options', [
            'label' => esc_html__('گزینه ها (comma separated)', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXT,
            'condition' => [
                'field_type' => ['select', 'radio']
            ]
        ]);

        $repeater->add_control('field_column', [
            'label' => esc_html__('عرض فیلد', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::SELECT,
            'default' => 'column-12',
            'options' => [
                'column-3' => '1/4',
                'column-4' => '1/3',
                'column-6' => '1/2',
                'column-12' => '1'
            ]
        ]);

        $this->add_control(
            'form_fields',
            [
                'label' => esc_html__('فیلدها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => []
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section('fields_style', [
            'label' => esc_html__('استایل فیلدها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->start_controls_tabs('fields_style_tabs');

        $this->start_controls_tab('field_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_control(
            'label_text_color',
            [
                'label' => esc_html__('رنگ برچسب', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .field-column label' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'label_typo',
                'selector' => '{{WRAPPER}} .field-column label'
            ]
        );


        $this->add_control(
            'field_text_color',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input, {{WRAPPER}} textarea, {{WRAPPER}} select' => 'color: {{VALUE}}'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'field_background',
            [
                'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input, {{WRAPPER}} textarea, {{WRAPPER}} select' => 'background: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'field_border',
                'selector' => '{{WRAPPER}} input, {{WRAPPER}} textarea, {{WRAPPER}} select'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typo',
                'selector' => '{{WRAPPER}} input, {{WRAPPER}} textarea, {{WRAPPER}} select'
            ]
        );

        $this->add_responsive_control(
            'field_padding',
            [
                'label' => esc_html__('فضای داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [

                    '{{WRAPPER}} input, {{WRAPPER}} textarea, {{WRAPPER}} select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'field_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [

                    '{{WRAPPER}} input, {{WRAPPER}} textarea, {{WRAPPER}} select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('field_hover', [
            'label' => esc_html__('شناوری', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_control(
            'field_hover_bg',
            [
                'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input:hover, {{WRAPPER}} textarea:hover, {{WRAPPER}} select:hover' => 'background: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'field_hover_border_color',
            [
                'label' => esc_html__('رنگ حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input:hover, {{WRAPPER}} textarea:hover, {{WRAPPER}} select:hover' => 'border-color: {{VALUE}}'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('field_focus', [
            'label' => esc_html__('تمرکز', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_control(
            'field_focus_bg',
            [
                'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input:focus, {{WRAPPER}} textarea:focus, {{WRAPPER}} select:focus' => 'background: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'field_focus_border_color',
            [
                'label' => esc_html__('رنگ حاشیه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input:focus, {{WRAPPER}} textarea:focus, {{WRAPPER}} select:focus' => 'border-color: {{VALUE}}'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section('submit_button_section', [
            'label' => esc_html__('استایل دکمه ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->start_controls_tabs('buttons_style_tabs');

        $this->start_controls_tab('button_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_control(
            'submit_color',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-contact-form button' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'submit_typo',
                'selector' => '{{WRAPPER}} .accountino-contact-form button'
            ]
        );

        $this->add_control(
            'submit_bg',
            [
                'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-contact-form button' => 'background: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} button'
            ]
        );


        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__('فضای داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [

                    '{{WRAPPER}} button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'button_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [

                    '{{WRAPPER}} button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('button_hover', [
            'label' => esc_html__('شناوری', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_control(
            'button_color_hover',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-contact-form button:hover' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'button_bg_hover',
            [
                'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-contact-form button:hover' => 'background: {{VALUE}}'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>
        <form class="accountino-contact-form" id="accountino-contact-form" method="post">
            <input type="hidden" name="action" value="accountino_ajax_contact_form">
            <input type="hidden" name="form_id" value="<?php echo esc_attr($this->get_id()); ?>">
            <div class="row">
                <?php foreach ($settings['form_fields'] as $field): ?>
                    <div class="field-column <?php echo esc_attr($field['field_column']); ?>">
                        <label>
                            <?php
                            $label = esc_html($field['field_label']);
                            echo !empty($label) && $field['field_type'] != 'button' ? "{$label}:" : null;


                            $name = esc_attr($field['field_name']);
                            $required = !empty($field['field_required']) ? 'required' : '';
                            $placeholder = esc_attr($field['field_placeholder']);

                            $fieldDirection = ($field['field_type'] == 'email' || $field['field_type'] == 'tel' ? 'direction: ltr;' : '');

                            switch ($field['field_type']) {
                                case 'textarea':
                                    echo "<textarea name='{$name}' rows='5' placeholder='{$placeholder}' {$required}></textarea>";
                                    break;
                                case 'select':
                                    echo "<select name='{$name}' {$required}>";
                                    $options = explode(',', $field['field_options']);
                                    foreach ($options as $opt) {
                                        echo '<option value="' . esc_attr(trim($opt)) . '">' . esc_html(trim($opt)) . '</option>';
                                    }
                                    echo '</select>';
                                    break;
                                case 'radio':
                                    $options = explode(',', $field['field_options']);
                                    foreach ($options as $opt) {
                                        echo "<label><input type='radio' name='{$name}' value='" . esc_attr(trim($opt)) . "' {$required}> " . esc_html(trim($opt)) . "</label> ";
                                    }
                                    break;
                                case 'checkbox':
                                    echo "<input type='checkbox' name='{$name}' value='1' {$required}>";
                                    break;
                                case 'button':
                                    echo "<button type='submit' name='{$name}' value='{$label}'>{$label}</button>";
                                    break;
                                default:
                                    echo "<input type='{$field['field_type']}' $fieldDirection name='{$name}' placeholder='{$placeholder}' {$required}>";
                            }
                            ?>
                        </label>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="accountino-form-message"></div>
        </form>

        <script>
            jQuery(function($) {
                $('#accountino-contact-form').on('submit', function(e) {
                    e.preventDefault();
                    var form = $(this);
                    var formData = form.serialize();

                    form.css('opacity', .5);

                    $.ajax({
                        type: 'POST',
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        data: formData,
                        success: function(response) {
                            form.find('.accountino-form-message').html('<div class="accountino-success-message">' + response.data + '</div>');
                            form[0].reset();
                        },
                        error: function(response) {
                            form.find('.accountino-form-message').html('<div class="accountino-error-message">' + response.responseText + '</div>');
                        },
                        complete: () => {
                            form.css('opacity', 1);
                        }
                    });
                });
            });
        </script>
<?php
    }
}
