<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Faq extends Widget_Base
{

    public function get_name()
    {
        return 'faq_widget';
    }

    public function get_title()
    {
        return esc_html__('سوالات متداول', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-accordion';
    }

    public function get_keywords()
    {
        return ['FAQ', 'سوالات پرتکرار', 'سوالات متداول'];
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    protected function register_controls()
    {
        // Content Section
        $this->start_controls_section('content_section', [
            'label' => esc_html__('سوالات', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);


        $repeater = new Repeater();

        $repeater->add_control(
            'active',
            [
                'label' => esc_html__('نمایش پاسخ', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('بله', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('خیر', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
            ]
        );

        $repeater->add_control('title', [
            'label' => esc_html__('پرسش', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXT,
        ]);

        $repeater->add_control('item_text', [
            'label' => esc_html__('پاسخ', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXTAREA,
        ]);


        $this->add_control('faq_items', [
            'label' => esc_html__('لیست', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'title_field' => '{{{ title }}}',
        ]);

        $this->add_responsive_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین آیتم ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 20,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-faq' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        // Style Section Box
        $this->start_controls_section('style_section_box', [
            'label' => esc_html__('استایل', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('item_background', [
            'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item' => 'background-color: {{VALUE}};',
            ],
        ]);

        $this->add_responsive_control('item_padding', [
            'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_responsive_control('item_radius', [
            'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('رنگ عنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item__title' => 'color: {{VALUE}};'
            ],
            'separator' => 'before'
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typo',
            'selector' => '{{WRAPPER}} .accountino-faq-item__title',
        ]);


        $this->add_control('item_answer_background', [
            'label' => esc_html__('پس زمینه پاسخ', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item__answer' => 'background-color: {{VALUE}};',
            ],
            'separator' => 'before'
        ]);

        $this->add_responsive_control('item_answer_padding', [
            'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item__answer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_responsive_control('item_answer_radius', [
            'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item__answer' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_control('text_color', [
            'label' => esc_html__('رنگ پاسخ', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item__text' => 'color: {{VALUE}};'
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'text_typo',
            'selector' => '{{WRAPPER}} .accountino-faq-item__text',
        ]);

        $this->end_controls_section();

        // Style Section Box
        $this->start_controls_section('button_style_section_box', [
            'label' => esc_html__('استایل دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->start_controls_tabs('button_style_tabs');

        $this->start_controls_tab(
            'button_style_tab_normal',
            [
                'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control('box_background', [
            'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item__button' => 'background-color: {{VALUE}};',
            ],
        ]);

        $this->add_responsive_control('box_padding', [
            'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item__button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_responsive_control('box_radius', [
            'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item__button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_control('button_text_color', [
            'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item__button' => 'color: {{VALUE}};'
            ],
            'separator' => 'before'
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'counting_typo',
            'selector' => '{{WRAPPER}} .accountino-faq-item__button ',
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_style_tab_hover',
            [
                'label' => esc_html__('شناوری', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control('box_background_hover', [
            'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item__button:hover' => 'background-color: {{VALUE}};',
            ],
        ]);

        $this->add_control('button_text_color_hover', [
            'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-faq-item__button:hover' => 'color: {{VALUE}};'
            ],
            'separator' => 'before'
        ]);


        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (empty($settings['faq_items']))
            return;

        echo "<ul class='accountino-faq'>";
        $counter = 1;
        foreach ($settings['faq_items'] as $faqItem) { ?>
            <li class="accountino-faq-item">
                <div class="accountino-faq-item__question">
                    <p class="accountino-faq-item__title"><?= esc_html__($faqItem['title']); ?></p>
                    <span class="accountino-faq-item__button" onclick="showFaq(this)" data-collapsed="<?= $faqItem['active'] == 'yes' ? 'false' : 'true'; ?>"></span>
                </div>
                <div class="accountino-faq-item__answer" style="<?= $faqItem['active'] !== 'yes' ? 'display: none;' : ''; ?>">
                    <p class="accountino-faq-item__text"><?= esc_html__($faqItem['item_text']); ?></p>
                </div>
            </li>
        <?php
            $counter++;
        }
        ?>
        </ul>

        <script>
            function showFaq(btn) {
                const faqBox = jQuery(btn).closest('.accountino-faq-item');

                faqBox.find('.accountino-faq-item__answer').slideToggle(function() {
                    if (this.style.display == 'none') {
                        btn.dataset.collapsed = 'true';
                    } else {
                        btn.dataset.collapsed = 'false';
                    }
                });
            }
        </script>
<?php
    }
}
