<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Utils;

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Customer_Review extends Widget_Base
{

    public function get_name()
    {
        return 'customer_review_widget';
    }

    public function get_title()
    {
        return esc_html__('نظرات مشتریان', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-testimonial';
    }

    public function get_keywords()
    {
        return ['Testimonials', 'نظرات مشتریان', 'مشتری'];
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    protected function register_controls()
    {
        $this->start_controls_section('content_section', [
            'label' => esc_html__('نظرات مشتریان', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $repeater = new Repeater();

        $repeater->add_control('image', [
            'label' => esc_html__('عکس مشتری', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::MEDIA,
            'default' => [
                'url' => Utils::get_placeholder_image_src(),
            ],
        ]);

        $repeater->add_control('name', [
            'label' => esc_html__('نام مشتری', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('نام مشتری', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $repeater->add_control('subtitle', [
            'label' => esc_html__('زیرعنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('زیرعنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $repeater->add_control('description', [
            'label' => esc_html__('متن نظر', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXTAREA,
            'default' => esc_html__('نظر مشتری', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $this->add_control('reviews', [
            'label' => esc_html__('لیست نظرات', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [],
        ]);

        $this->end_controls_section();

        // Styles
        $this->start_controls_section('style_section', [
            'label' => esc_html__('استایل', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('box_background', [
            'label' => esc_html__('پس زمینه توضیحات', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-cr-items-right' => 'background-color: {{VALUE}};',
            ],
        ]);

        $this->add_responsive_control('box_padding', [
            'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-cr-items-right' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_responsive_control('box_radius', [
            'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-cr-items-right' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);


        $this->add_control('desc_box_background', [
            'label' => esc_html__('پس زمینه نظرات', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-cr-items-left' => 'background-color: {{VALUE}};',
            ],
            'separator' => 'before'
        ]);

        $this->add_responsive_control('desc_padding', [
            'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-cr-items-left' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_responsive_control('desc_radius', [
            'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-cr-items-left' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);


        $this->add_responsive_control('image_size', [
            'label' => esc_html__('سایز عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::SLIDER,
            'selectors' => [
                '{{WRAPPER}} .accountino-cr-items-right__image' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
            ],
            'separator' => 'before'
        ]);

        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'image_border',
            'selector' => '{{WRAPPER}} .accountino-cr-items-right__image',
        ]);

        $this->add_control('image_radius', [
            'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-cr-items-right__image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);



        $this->add_control('name_color', [
            'label' => esc_html__('متن رنگ نام مشتری', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-cr-items-right__name' => 'color: {{VALUE}};',
            ],
            'separator' => 'before'
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'name_typography',
            'selector' => '{{WRAPPER}} .accountino-cr-items-right__name',
        ]);


        $this->add_control('subtitle_color', [
            'label' => esc_html__('رنگ متن زیرعنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-cr-items-right__subtitle' => 'color: {{VALUE}};',
            ],
            'separator' => 'before'
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'subtitle_typography',
            'selector' => '{{WRAPPER}} .accountino-cr-items-right__subtitle',
        ]);


        $this->add_control('description_color', [
            'label' => esc_html__('رنگ متن نظر', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-cr-items-left__description' => 'color: {{VALUE}};',
            ],
            'separator' => 'before'
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'description_typography',
            'selector' => '{{WRAPPER}} .accountino-cr-items-left__description',
        ]);

        $this->add_control(
            'striped_bg',
            [
                'label' => esc_html__('هاشور پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('Yes', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('No', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'striped_bg_color',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'striped_bg' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-cr-items-right' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        echo '<div class="accountino-customer-review">';
        foreach ($settings['reviews'] as $review) { ?>
            <div class="accountino-cr-items">
                <div class="accountino-cr-items-right">
                    <img class="accountino-cr-items-right__image" src="<?= esc_url($review['image']['url']); ?>" alt="<?= esc_attr($review['name']); ?>" />
                    <h4 class="accountino-cr-items-right__name"><?= esc_html($review['name']); ?></h4>
                    <p class="accountino-cr-items-right__subtitle"><?= esc_html($review['subtitle']); ?></p>
                </div>
                <div class="accountino-cr-items-left">
                    <p class="accountino-cr-items-left__description">
                        <?= esc_html($review['description']); ?>
                    </p>
                </div>
            </div>
<?php
        }
        echo '</div>';
    }
}
