<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Icons_Manager;

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Custom_List extends Widget_Base
{

    public function get_name()
    {
        return 'custom_list_widget';
    }

    public function get_title()
    {
        return esc_html__('لیست', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    public function get_keywords()
    {
        return ['List', 'فهرست', 'لیست'];
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    protected function register_controls()
    {
        // Content Section
        $this->start_controls_section('content_section', [
            'label' => esc_html__('آیتم ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);


        $repeater = new Repeater();

        $repeater->add_control(
            'counting',
            [
                'label' => esc_html__('شماره گذاری', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('بله', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('خیر', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
            ]
        );
        $repeater->add_control('icon', [
            'label' => esc_html__('آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::ICONS,
            'condition' => [
                'counting!' => 'yes'
            ],
        ]);

        $repeater->add_control('title', [
            'label' => esc_html__('عنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('عنوان آیتم', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);

        $repeater->add_control('item_text', [
            'label' => esc_html__('متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::TEXTAREA,
            'default' => esc_html__('متن آیتم', ACCOUNTINO_CORE_WIDGETS_PANEL),
        ]);


        $this->add_control('list_items', [
            'label' => esc_html__('لیست', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'title_field' => '{{{ title }}}',
        ]);

        $this->add_responsive_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین آیتم ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 20,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-list' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        // Style Section Box
        $this->start_controls_section('style_section_box', [
            'label' => esc_html__('استایل', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_responsive_control('icon_space', [
            'label' => esc_html__('فاصله آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::SLIDER,
            'selectors' => [
                '{{WRAPPER}} .accountino-custom-list-item__icon' => 'margin-left: {{SIZE}}{{UNIT}};',
            ],
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('رنگ عنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-custom-list-item__title' => 'color: {{VALUE}};'
            ],
            'separator' => 'before'
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typo',
            'selector' => '{{WRAPPER}} .accountino-custom-list-item__title',
        ]);

        $this->add_control('text_color', [
            'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-custom-list-item__text' => 'color: {{VALUE}};'
            ],
            'separator' => 'before'
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'text_typo',
            'selector' => '{{WRAPPER}} .accountino-custom-list-item__text',
        ]);

        $this->add_control('icon_color', [
            'label' => esc_html__('رنگ آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-custom-list-item__icon' => 'color: {{VALUE}};',
                '{{WRAPPER}} .accountino-custom-list-item__icon .accountino-bullet' => 'background-color: {{VALUE}};',
                '{{WRAPPER}} .accountino-custom-list-item__icon svg, {{WRAPPER}} .accountino-custom-list-item__icon g, {{WRAPPER}} .accountino-custom-list-item__icon path' => 'fill: {{VALUE}};',
            ],
            'separator' => 'before'
        ]);

        $this->add_responsive_control('icon_size', [
            'label' => esc_html__('سایز آیکن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::SLIDER,
            'selectors' => [
                '{{WRAPPER}} .accountino-custom-list-item__icon svg, {{WRAPPER}} .accountino-custom-list-item__icon i' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
            ],
        ]);

        $this->end_controls_section();

        // Style Section Box
        $this->start_controls_section('counting_style_section_box', [
            'label' => esc_html__('استایل شماره گذاری', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('box_background', [
            'label' => esc_html__('پس زمینه', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-custom-list-item-icon__counter' => 'background-color: {{VALUE}};',
            ],
        ]);

        $this->add_responsive_control('box_padding', [
            'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-custom-list-item-icon__counter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_responsive_control('box_radius', [
            'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .accountino-custom-list-item-icon__counter' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_control('counting_color', [
            'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .accountino-custom-list-item-icon__counter' => 'color: {{VALUE}};'
            ],
            'separator' => 'before'
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'counting_typo',
            'selector' => '{{WRAPPER}} .accountino-custom-list-item-icon__counter ',
        ]);


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (empty($settings['list_items']))
            return;

        echo "<ul class='accountino-custom-list'>";
        $counter = 1;
        foreach ($settings['list_items'] as $listItem) { ?>
            <li class="accountino-custom-list-item">
                <span class="accountino-custom-list-item__icon">
                    <?php
                    if (!empty($listItem['counting']) && $listItem['counting'] == 'yes') {
                        echo "<span class='accountino-custom-list-item-icon__counter'>" . esc_html__($counter) . "</span>";
                    } elseif (!empty($listItem['icon']['library'])) {
                        Icons_Manager::render_icon($listItem['icon'], ['aria-hidden' => 'true']);
                    } else {
                        echo '<i class="accountino-bullet"></i>';
                    }
                    ?>
                </span>
                <div>
                    <p class="accountino-custom-list-item__title"><?= esc_html__($listItem['title']); ?></p>
                    <p class="accountino-custom-list-item__text"><?= esc_html__($listItem['item_text']); ?></p>
                </div>
            </li>
<?php
            $counter++;
        }
        echo '</ul>';
    }
}
