<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use ELementor\Group_Control_Typography;
use ELementor\Group_Control_Text_Stroke;
use ELementor\Group_Control_Text_Shadow;
use ELementor\Group_Control_Border;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;


if (! defined('ABSPATH')) {
    exit;
}

class Custom_Heading extends Widget_Base
{

    public function get_name()
    {
        return 'custom_heading_widget';
    }

    public function get_title()
    {
        return __('تیتر', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-t-letter';
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    public function get_keywords()
    {
        return ['heading', 'title', 'هدینگ', 'تایتل', 'عنوان', ACCOUNTINO_CORE_WIDGETS_PANEL];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            [
                'label' => esc_html__('تیتر', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::TEXTAREA,
                'ai' => [
                    'type' => 'text',
                ],
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('عنوان خود را وارد کنید', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'default' => esc_html__('عنوان خود را اینجا وارید کنید', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'title2',
            [
                'label' => esc_html__('عنوان دوم', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::TEXTAREA,
                'ai' => [
                    'type' => 'text',
                ],
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('عنوان دوم خود را وارد کنید', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'default' => esc_html__('عنوان دوم خود را اینجا وارید کنید', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__('لینک', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '',
                ],
            ]
        );

        $this->add_control(
            'size',
            [
                'label' => esc_html__('سایز', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'default' => esc_html__('پیش فرض', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'small' => esc_html__('کوچک', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'medium' => esc_html__('متوسط', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'large' => esc_html__('بزرگ', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'xl' => esc_html__('XL', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'xxl' => esc_html__('XXL', ACCOUNTINO_CORE_WIDGETS_PANEL),
                ],
                'default' => 'default',
                'condition' => [
                    'size!' => 'default', // a workaround to hide the control, unless it's in use (not default).
                ],
            ]
        );

        $this->add_control(
            'header_size',
            [
                'label' => esc_html__('تگ HTML', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h3',
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__('عنوان', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__('موقعیت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('چپ', ACCOUNTINO_CORE_WIDGETS_PANEL),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('وسط', ACCOUNTINO_CORE_WIDGETS_PANEL),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('راست', ACCOUNTINO_CORE_WIDGETS_PANEL),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('کشیده', ACCOUNTINO_CORE_WIDGETS_PANEL),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
                ],
                'selector' => '{{WRAPPER}} .accountino-custom-heading__title',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Stroke::get_type(),
            [
                'name' => 'text_stroke',
                'selector' => '{{WRAPPER}} .accountino-custom-heading__title',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'text_shadow',
                'selector' => '{{WRAPPER}} .accountino-custom-heading__title',
            ]
        );

        $this->add_control(
            'separator',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->start_controls_tabs('title_colors');

        $this->start_controls_tab(
            'title_colors_normal',
            [
                'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'global' => [
                    'default' => Global_Colors::COLOR_PRIMARY,
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-heading__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_first_letter_color',
            [
                'label' => esc_html__('رنگ حرف اول', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'description' => esc_html__('برای تنظیم رنگ هر کلمه که می خواهید رنگ حرف اول تغییر کند را داخل تگ span قرار دهید.', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-heading__title1 span::first-letter' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_colors_hover',
            [
                'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-heading__title:hover .accountino-custom-heading__title1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_hover_first_letter_color',
            [
                'label' => esc_html__('رنگ حرف اول', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-heading__title:hover .accountino-custom-heading__title1 span::first-letter' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_link_hover_color',
            [
                'label' => esc_html__('رنگ لینک', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-heading__title a:hover, {{WRAPPER}} .accountino-custom-heading__title a:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color_transition_duration',
            [
                'label' => esc_html__('مدت زمان حرکت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['s', 'ms', 'custom'],
                'default' => [
                    'unit' => 's',
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-heading__title a' => 'transition-duration: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();


        //  Heading 2 Styles

        $this->start_controls_section(
            'section_title2_style',
            [
                'label' => esc_html__('عنوان دوم', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'align_title2',
            [
                'label' => esc_html__('موقعیت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('چپ', ACCOUNTINO_CORE_WIDGETS_PANEL),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('وسط', ACCOUNTINO_CORE_WIDGETS_PANEL),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('راست', ACCOUNTINO_CORE_WIDGETS_PANEL),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('کشیده', ACCOUNTINO_CORE_WIDGETS_PANEL),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-heading__title2' => 'text-align: {{VALUE}};',
                ],
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography_title2',
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
                ],
                'selector' => '{{WRAPPER}} .accountino-custom-heading__title2',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Stroke::get_type(),
            [
                'name' => 'text_stroke_title2',
                'selector' => '{{WRAPPER}} .accountino-custom-heading__title2',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'text_shadow_title2',
                'selector' => '{{WRAPPER}} .accountino-custom-heading__title2',
            ]
        );

        $this->add_responsive_control(
            'title2_space',
            [
                'label' => esc_html__('فاصله بین عنوان ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 10,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-heading__title' => 'gap: {{SIZE}}{{UNIT}} 0;',
                ],
            ]
        );

        $this->add_control(
            'separator_title2',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->start_controls_tabs('title2_colors');

        $this->start_controls_tab(
            'title_colors2_normal',
            [
                'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'title2_color',
            [
                'label' => esc_html__('رنگ متن', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'global' => [
                    'default' => Global_Colors::COLOR_PRIMARY,
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-heading__title2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title2_colors_hover',
            [
                'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL),
            ]
        );

        $this->add_control(
            'title2_hover_color',
            [
                'label' => esc_html__('رنگ لینک', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-heading__title2 a:hover, {{WRAPPER}} .accountino-custom-heading__title a:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title2_hover_color_transition_duration',
            [
                'label' => esc_html__('مدت زمان حرکت', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['s', 'ms', 'custom'],
                'default' => [
                    'unit' => 's',
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-custom-heading__title2 a' => 'transition-duration: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if ('' === $settings['title'] && '' === $settings['title2']) {
            return;
        }

        $this->add_render_attribute('title', 'class', 'accountino-custom-heading__title');

        if (! empty($settings['size'])) {
            $this->add_render_attribute('title', 'class', 'elementor-size-' . $settings['size']);
        } else {
            $this->add_render_attribute('title', 'class', 'elementor-size-default');
        }

        $this->add_inline_editing_attributes('title');

        $title = wp_kses_post($settings['title']);

        if (! empty($settings['link']['url'])) {
            $this->add_link_attributes('url', $settings['link']);
            $title = sprintf('<a %1$s>%2$s</a>', $this->get_render_attribute_string('url'), $title);
        }

        $title2 = wp_kses_post($settings['title2']);

        echo sprintf('<%1$s %2$s><span class="accountino-custom-heading__title1">%3$s</span><span class="accountino-custom-heading__title2">%4$s</span></%1$s>', Utils::validate_html_tag($settings['header_size']), $this->get_render_attribute_string('title'), $title, $title2);
    }
}
