<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Button;

class Button extends Widget_Button
{
    public function get_name()
    {
        return 'button_widget';
    }

    public function get_title()
    {
        return __('دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-button';
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    protected function _register_controls()
    {

        parent::register_controls();


        $this->update_control(
            'button_type',
            [
                'options' => [
                    'hatchery' => esc_html__('هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                ],
            ],
            [
                'recursive' => true,
            ]
        );
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (empty($settings['text']) && empty($settings['selected_icon']['value'])) {
            return;
        }

        $this->add_render_attribute('wrapper', 'class', 'elementor-button-wrapper');

        $this->add_render_attribute('button', 'class', 'elementor-button');

        if (! empty($settings['link']['url'])) {
            $this->add_link_attributes('button', $settings['link']);
            $this->add_render_attribute('button', 'class', 'elementor-button-link');
        } else {
            $this->add_render_attribute('button', 'role', 'button');
        }

        if (! empty($settings['button_css_id'])) {
            $this->add_render_attribute('button', 'id', $settings['button_css_id']);
        }

        if (! empty($settings['button_hover_border_color']) && $settings['button_type'] == 'hatchery') {
            $this->add_render_attribute('button', 'style', "--button-hatchery-color: {$settings['button_hover_border_color']};");
            $this->add_render_attribute('button', 'class', "hatchery-button");
        }

        if (!empty($settings['selected_icon']['value']) && !empty($settings['hover_color'])) {
            $this->add_render_attribute('button', 'style', "--button-icon-hover-color: {$settings['hover_color']};");
        }

        if (! empty($settings['size'])) {
            $this->add_render_attribute('button', 'class', 'elementor-size-' . $settings['size']);
        } else {
            $this->add_render_attribute('button', 'class', 'elementor-size-sm'); // BC, to make sure the class is always present
        }

        if (! empty($settings['hover_animation'])) {
            $this->add_render_attribute('button', 'class', 'elementor-animation-' . $settings['hover_animation']);
        }
?>
        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <a <?php $this->print_render_attribute_string('button'); ?>>
                <?php $this->render_text($this); ?>
            </a>
        </div>
<?php
    }
}
