<?php

namespace AccountinoCore\Widgets;

use Accountino_Shamsi_Date_Service;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Css_Filter;
use Elementor\Utils;

if (! defined('ABSPATH')) exit; // Exit if accessed directly

class Blog_List extends Widget_Base
{

    public function get_name()
    {
        return 'blog_list_widget';
    }

    public function get_title()
    {
        return esc_html__('وبلاگ', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-posts-grid';
    }

    public function get_keywords()
    {
        return ['Blog', 'بلاگ', 'وبلاگ', 'پست'];
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    public function register_controls()
    {
        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوا', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'post_categories',
            [
                'label' => esc_html__('دسته بندی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_post_categories(),
            ]
        );

        $this->add_control(
            'include_posts',
            [
                'label' => esc_html__('لیست مشخص از نوشته ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => $this->get_posts_list(), // Define below
            ]
        );

        $this->add_control(
            'exclude_posts',
            [
                'label' => esc_html__('نوشته هایی که نمایش داده نشود', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => $this->get_posts_list(),
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => esc_html__('تعداد محصولات', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::NUMBER,
                'default' => 4,
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__('ترتیب نمایش', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'ASC' => esc_html__('صعودی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                    'DESC' => esc_html__('نزولی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                ],
            ]
        );

        $this->add_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین کارت ها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 20,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-grid' => 'gap: 0 {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('post_style_tabs');

        // Normal Tab
        $this->start_controls_tab('post_style_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ متن نام نوشته', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main__title',
            ]
        );

        $this->add_control(
            'short_description_color',
            [
                'label' => esc_html__('رنگ متن توضیحات کوتاه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main-details__description' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main-details__date' => 'color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'short_description_typography',
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main-details__description',
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main-details__date'
                ]
            ]
        );

        $this->add_control(
            'image_background',
            [
                'label' => esc_html__('پس زمینه عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-top__shapes' => 'background-color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'striped_top_section',
            [
                'label' => esc_html__('هاشور پس زمینه عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__('Yes', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'label_off' => esc_html__('No', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'return_value' => 'yes',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'striped_top_section_color',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'striped_top_section' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-top__shapes' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
                'separator' => 'after'
            ]
        );


        $this->add_control(
            'box_background',
            [
                'label' => esc_html__('پس زمینه باکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'box_border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );



        $this->end_controls_tab();

        // Hover Tab
        $this->start_controls_tab('post_style_hover', [
            'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__('رنگ متن نام نوشته', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box:hover .accountino-blog-box-main__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'short_description_color_hover',
            [
                'label' => esc_html__('رنگ متن توضیحات کوتاه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box:hover .accountino-blog-box-main-details__description' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .accountino-blog-box:hover .accountino-blog-box-main-details__date' => 'color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );


        $this->add_control(
            'image_background_hover',
            [
                'label' => esc_html__('پس زمینه عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box:hover .accountino-blog-box-top__shapes' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'striped_top_section_color_hover',
            [
                'label' => esc_html__('رنگ هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'striped_top_section' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box:hover .accountino-blog-box-top__shapes' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                    '{{WRAPPER}} .accountino-blog-box:hover .accountino-blog-box-main__button' => 'background-image: repeating-linear-gradient(125deg, transparent, transparent 14px, {{VALUE}} 15px);',
                ],
            ]
        );

        $this->add_control(
            'box_background_hover',
            [
                'label' => esc_html__('پس زمینه باکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box:hover .accountino-blog-box-main' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        // Button Style
        $this->start_controls_section(
            'button_style_section',
            [
                'label' => esc_html__('استایل دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('button_style_tabs');

        // Normal Tab
        $this->start_controls_tab('button_style_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'button_background_color',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main__button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => esc_html__('رنگ دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main__button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main__button'
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main__button'
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main__button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله داخلی', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-main__button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_tab();

        // Button Hover Tab
        $this->start_controls_tab('button_style_hover', [
            'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'button_background_color_hover',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box:hover .accountino-blog-box-main__button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_text_color_hover',
            [
                'label' => esc_html__('رنگ دکمه', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box:hover .accountino-blog-box-main__button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border_hover',
                'selector' => '{{WRAPPER}} .accountino-blog-box:hover .accountino-blog-box-main__button'
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        // Image Style
        $this->start_controls_section(
            'image_style_section',
            [
                'label' => esc_html__('استایل عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('image_style_tabs');

        // Normal Tab
        $this->start_controls_tab('image_style_normal', [
            'label' => esc_html__('عادی', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_control(
            'image_border_radius',
            [
                'label' => esc_html__('گردی مرزها', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .accountino-blog-box-top__image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'image_css_filters',
                'label' => esc_html__('فیلتر های CSS عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .accountino-blog-box .accountino-blog-box-top__image img',
            ]
        );


        $this->end_controls_tab();

        // Image Hover Tab
        $this->start_controls_tab('image_style_hover', [
            'label' => esc_html__('شناور', ACCOUNTINO_CORE_WIDGETS_PANEL)
        ]);

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'image_css_filters_hover',
                'label' => esc_html__('فیلتر های CSS عکس', ACCOUNTINO_CORE_WIDGETS_PANEL),
                'selector' => '{{WRAPPER}} .accountino-blog-box:hover .accountino-blog-box-top__image img',
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $args = [
            'post_type' => 'post',
            'posts_per_page' => $settings['posts_per_page'],
            'order' => $settings['order'],
        ];

        if (!empty($settings['post_categories'])) {
            $args['tax_query'] = [[
                'taxonomy' => 'category',
                'field'    => 'slug',
                'terms'    => $settings['post_categories'],
            ]];
        }

        if (!empty($settings['include_posts'])) {
            $args['post_in'] = $settings['include_posts'];
        }

        if (!empty($settings['exclude_posts'])) {
            $args['post__not_in'] = $settings['exclude_posts'];
        }

        $loop = new \WP_Query($args);

        if ($loop->have_posts()) {
            echo '<div class="accountino-blog-grid">';
            while ($loop->have_posts()) {
                $loop->the_post();
                global $post;

                $excerpt = get_the_excerpt();
                $excerpt = (!empty($excerpt) ? mb_substr(strip_tags($excerpt), 0, 30) . ' ...' : null);

                if (has_post_thumbnail()) {
                    $postImage = get_the_post_thumbnail(get_the_ID(), 'medium');;
                } else {
                    $postImage = '<img src="' . esc_url(Utils::get_placeholder_image_src()) . '" alt="Placeholder">';
                }

                echo "<div class='accountino-blog-box'>
                    <a href='" . get_the_permalink() . "'>
                        <div class='accountino-blog-box-top'>
                            <div class='accountino-blog-box-top__image'>
                                {$postImage}
                                <div class='accountino-blog-box-top__shapes'></div>
                            </div>
                            <div class='accountino-blog-box-top__circle'>
                            </div>
                        </div>
                        <div class='accountino-blog-box-main'>
                            <div class='accountino-blog-box-main__title'>
                                " . get_the_title() . "
                            </div>
                            <div class='accountino-blog-box-main-details'>
                                <div class='accountino-blog-box-main-details__description'>
                                {$excerpt}
                                </div>
                                <div class='accountino-blog-box-main-details__date'>
                                    <svg width='13' height='14' viewBox='0 0 13 14' fill='none' xmlns='http://www.w3.org/2000/svg'>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M1.52727 2.8V12.4727H11.2V2.8H1.52727ZM0 2.54545C0 1.84255 0.569819 1.27273 1.27273 1.27273H11.4545C12.1575 1.27273 12.7273 1.84255 12.7273 2.54545V12.7273C12.7273 13.4302 12.1575 14 11.4545 14H1.27273C0.569819 14 0 13.4302 0 12.7273V2.54545Z' fill='#0EFDC2'/>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M9.41818 0C9.83993 0 10.1818 0.341892 10.1818 0.763636V2.03636C10.1818 2.45811 9.83993 2.8 9.41818 2.8C8.99644 2.8 8.65454 2.45811 8.65454 2.03636V0.763636C8.65454 0.341892 8.99644 0 9.41818 0Z' fill='#0EFDC2'/>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M3.30909 0C3.73084 0 4.07273 0.341892 4.07273 0.763636V2.03636C4.07273 2.45811 3.73084 2.8 3.30909 2.8C2.88735 2.8 2.54545 2.45811 2.54545 2.03636V0.763636C2.54545 0.341892 2.88735 0 3.30909 0Z' fill='#0EFDC2'/>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M0 5.09091C0 4.66916 0.341892 4.32727 0.763636 4.32727H11.9636C12.3854 4.32727 12.7273 4.66916 12.7273 5.09091C12.7273 5.51265 12.3854 5.85455 11.9636 5.85455H0.763636C0.341892 5.85455 0 5.51265 0 5.09091Z' fill='#0EFDC2'/>
                                    </svg> " . Accountino_Shamsi_Date_Service::convertToJalaliWithMonth(get_the_date()) . "
                                </div>
                            </div>
                            <div class='accountino-blog-box-main-card'>
                                <div class='accountino-blog-box-main-details__date_responsive accountino-blog-box-main-details__date'>
                                    <svg width='13' height='14' viewBox='0 0 13 14' fill='none' xmlns='http://www.w3.org/2000/svg'>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M1.52727 2.8V12.4727H11.2V2.8H1.52727ZM0 2.54545C0 1.84255 0.569819 1.27273 1.27273 1.27273H11.4545C12.1575 1.27273 12.7273 1.84255 12.7273 2.54545V12.7273C12.7273 13.4302 12.1575 14 11.4545 14H1.27273C0.569819 14 0 13.4302 0 12.7273V2.54545Z' fill='#0EFDC2'/>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M9.41818 0C9.83993 0 10.1818 0.341892 10.1818 0.763636V2.03636C10.1818 2.45811 9.83993 2.8 9.41818 2.8C8.99644 2.8 8.65454 2.45811 8.65454 2.03636V0.763636C8.65454 0.341892 8.99644 0 9.41818 0Z' fill='#0EFDC2'/>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M3.30909 0C3.73084 0 4.07273 0.341892 4.07273 0.763636V2.03636C4.07273 2.45811 3.73084 2.8 3.30909 2.8C2.88735 2.8 2.54545 2.45811 2.54545 2.03636V0.763636C2.54545 0.341892 2.88735 0 3.30909 0Z' fill='#0EFDC2'/>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M0 5.09091C0 4.66916 0.341892 4.32727 0.763636 4.32727H11.9636C12.3854 4.32727 12.7273 4.66916 12.7273 5.09091C12.7273 5.51265 12.3854 5.85455 11.9636 5.85455H0.763636C0.341892 5.85455 0 5.51265 0 5.09091Z' fill='#0EFDC2'/>
                                    </svg> " . Accountino_Shamsi_Date_Service::convertToJalaliWithMonth(get_the_date()) . "
                                </div>
                                <span class='accountino-blog-box-main__button'>
                                    مشاهده
                                </span>
                            </div>
                        </div>
                    </a>
                </div>";
            }
            echo '</div>';
        } else {
            echo '<p>' . esc_html__('هیچ نوشته ای یافت نشد.', ACCOUNTINO_CORE_WIDGETS_PANEL) . '</p>';
        }

        wp_reset_postdata();
    }

    private function get_post_categories()
    {
        $terms = get_categories();
        $options = [];
        foreach ($terms as $term) {
            $options[$term->term_id] = $term->name;
        }
        return $options;
    }

    private function get_posts_list()
    {
        $args = array(
            'post_type' => 'post',
            'orderby'    => 'ID',
            'post_status' => 'publish',
            'order'    => 'DESC',
            'posts_per_page' => -1 // this will retrive all the post that is published 
        );

        $posts = get_posts($args);

        $options = [];
        foreach ($posts as $post) {
            $options[$post->ID] = get_the_title($post->ID);
        }
        return $options;
    }
}
