<?php

namespace AccountinoCore\Widgets;

use Elementor\Widget_Button;

class Account extends Widget_Button
{
    public function get_name()
    {
        return 'account_widget';
    }

    public function get_title()
    {
        return __('منو حساب کاربری', ACCOUNTINO_CORE_WIDGETS_PANEL);
    }

    public function get_icon()
    {
        return 'eicon-user-circle-o';
    }

    public function get_categories()
    {
        return [ACCOUNTINO_CORE_PANEL_CATEGORY];
    }

    protected function _register_controls()
    {

        parent::register_controls();


        $this->update_control(
            'link',
            [
                'dynamic' => [
                    'default' => \AccountinoCore\Plugin::elementor()->dynamic_tags->tag_data_to_tag_text(null, 'login-url'),
                ],
            ],
            [
                'recursive' => true,
            ]
        );


        $this->update_control(
            'button_type',
            [
                'options' => [
                    'hatchery' => esc_html__('هاشور', ACCOUNTINO_CORE_WIDGETS_PANEL),
                ],
            ],
            [
                'recursive' => true,
            ]
        );
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (empty($settings['text']) && empty($settings['selected_icon']['value'])) {
            return;
        }

        $this->add_render_attribute('wrapper', 'class', 'elementor-button-wrapper user-account-widget');

        $this->add_render_attribute('button', 'class', 'elementor-button');

        if (! empty($settings['link']['url']) && !is_user_logged_in()) {
            $this->add_link_attributes('button', $settings['link']);
            $this->add_render_attribute('button', 'class', 'elementor-button-link');
        } else {
            $this->add_render_attribute('button', 'role', 'button');
            $this->add_render_attribute('button', 'onclick', 'openUserBox(this)');
        }

        if (! empty($settings['button_css_id'])) {
            $this->add_render_attribute('button', 'id', $settings['button_css_id']);
        }

        if (! empty($settings['button_hover_border_color']) && $settings['button_type'] == 'hatchery') {
            $this->add_render_attribute('button', 'style', "--button-hatchery-color: {$settings['button_hover_border_color']};");
            $this->add_render_attribute('button', 'class', "hatchery-button");
        }

        if (!empty($settings['selected_icon']['value']) && !empty($settings['hover_color'])) {
            $this->add_render_attribute('button', 'style', "--button-icon-hover-color: {$settings['hover_color']};");
        }

        if (! empty($settings['size'])) {
            $this->add_render_attribute('button', 'class', 'elementor-size-' . $settings['size']);
        } else {
            $this->add_render_attribute('button', 'class', 'elementor-size-sm'); // BC, to make sure the class is always present
        }

        if (! empty($settings['hover_animation'])) {
            $this->add_render_attribute('button', 'class', 'elementor-animation-' . $settings['hover_animation']);
        }

        $user = wp_get_current_user();

?>
        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <a <?php $this->print_render_attribute_string('button'); ?>>
                <?php $this->render_text($this); ?>
            </a>
            <div class="accountino-cart-box accountino-user-account-box hide">
                <div class="accountino-product-comment-meta">
                    <div class="accountino-product-comment-meta__avatar">
                        <?= get_avatar($user->ID, 60); ?>
                    </div>

                    <p class="accountino-woocommerce-review__author"><?= esc_html($user->display_name); ?></p>
                </div>
                <nav class="accountino-dashboard-navigation" aria-label="<?php esc_html_e('Account pages', 'woocommerce'); ?>">
                    <ul>
                        <?php
                        $show = ['dashboard', 'orders', 'contact_support', 'edit-address', 'customer-logout'];
                        foreach (wc_get_account_menu_items() as $endpoint => $label) :
                            if (!in_array($endpoint, $show)) continue;
                        ?>
                            <li class="<?php echo wc_get_account_menu_item_classes($endpoint); ?>">
                                <a href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>" <?php echo wc_is_current_account_menu_item($endpoint) ? 'aria-current="page"' : ''; ?>>
                                    <i class="item_icon"><?php include(ACCOUNTINO_ASSETS_PATH . "images/icons/{$endpoint}.svg"); ?></i>
                                    <span><?php echo esc_html($label); ?></span>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </nav>
            </div>
            <script>
                function openUserBox(btn) {
                    jQuery(btn).next().fadeToggle().toggleClass('hide');
                }
            </script>
        </div>
<?php
    }
}
