<?php

namespace AccountinoCore\Core;

use AccountinoCore\Plugin;

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

final class Modules_Manager
{
	/**
	 * @var Module_Base[]
	 */
	private $modules = [];

	public function __construct()
	{
		$modules = [
			'dynamic-tags',
			'mega-menu',
			'ajax-search',
			'woocommerce-cart',
			'form',
			'login',
		];

		foreach ($modules as $module_name) {
			$class_name = str_replace('-', ' ', $module_name);
			$class_name = str_replace(' ', '', ucwords($class_name));
			$class_name = '\AccountinoCore\Modules\\' . $class_name . '\Module';

			/** @var Module_Base $class_name */
			$experimental_data = $class_name::get_experimental_data();

			if ($experimental_data) {
				Plugin::elementor()->experiments->add_feature($experimental_data);

				if (! Plugin::elementor()->experiments->is_feature_active($experimental_data['name'])) {
					continue;
				}
			}

			if ($class_name::is_active()) {
				$this->modules[$module_name] = $class_name::instance();
			}
		}
	}

	/**
	 * @param string $module_name
	 *
	 * @return Module_Base|Module_Base[]
	 */
	public function get_modules($module_name)
	{
		if ($module_name) {
			if (isset($this->modules[$module_name])) {
				return $this->modules[$module_name];
			}

			return null;
		}

		return $this->modules;
	}
}
