jQuery(function ($) {
    const $form = $('.acountino-variable-product .variations_form');
    if (!$form.length || typeof $form.wc_variation_form !== 'function') return;

    let currentVariation = null;

    $form.wc_variation_form();

    // $form.on('found_variation', function (event, variation) {
    //     $form.find('.price').html(variation.price_html);
    // });

    $form.on('found_variation', function (event, variation) {
        currentVariation = variation;
        updateTotalPrice();
    });

    // Update total price on quantity change
    $form.on('input change', 'input.qty', function () {
        updateTotalPrice();
    });

    $form.on('woocommerce_variation_has_changed', function () {
        const $button = $form.find('.single_add_to_cart_button');
        const variationId = $form.find('.variation_id').val();
        $button.prop('disabled', !variationId);
    });

    $form.on('click', '.qty-plus', function () {
        let $qty = $form.find('.qty');
        let val = parseInt($qty.val());
        $qty.val(val + 1).change();
    });

    $form.on('click', '.qty-minus', function () {
        let $qty = $form.find('.qty');
        let val = parseInt($qty.val());
        if (val > 1) $qty.val(val - 1).change();
    });

    function updateTotalPrice() {
        if (!currentVariation) return;

        const qty = parseInt($form.find('input.qty').val(), 10) || 1;
        const price = parseFloat(currentVariation.display_price);
        const total = qty * price;

        const formattedTotal = new Intl.NumberFormat('fa-IR', {
            style: 'currency',
            currency: 'irr',
            currencyDisplay: "code"

        }).format(total).replace('IRR', '').trim();

        $form.find('.price').html(currentVariation.price_html);
        const symbol = $form.find('.price .woocommerce-Price-currencySymbol').clone();

        $form.find('.price .amount bdi').text(`${formattedTotal}`).append(symbol);
    }

});

function setVariation(selectedAttribute, fieldName) {
    fieldName = fieldName.replace('!!!preview', '');
    if (selectedAttribute)
        jQuery(`select[name="${fieldName}"]`).val(selectedAttribute).trigger('change');
}