const autoCompleteSearch = (wordToMatch) => {
    if (wordToMatch.length < 1) {
        displayData([]);
        return;
    }
    jQuery('.search_result').empty().addClass('loading').css('opacity', 1);

    var data = new FormData();
    data.append("action", 'ajax_search');
    data.append("s", wordToMatch);

    fetch(ajaxUrl, {
        method: "POST",
        body: data
    })
        .then(blob => blob.json())
        .then(data => displayData(data));
}

function displayData(searchResult) {
    searchResultsHtml = [];
    searchResult.map(item => {
        searchResultsHtml.push(`<li><a href='${item.url}'><span class="s-title">${item.title}</span></a></li>`);
    });

    if (!searchResultsHtml.length && jQuery('.elementor-search-form__input').val())
        searchResultsHtml = ['<li>موردی یافت نشد!</li>'];

    jQuery('.search_result').html(searchResultsHtml.join('')).removeClass('loading');
}

jQuery(document).ready(function () {
    setTimeout(() => {
        jQuery('header .elementor-widget-account_widget').clone().appendTo('.elementor-nav-menu--dropdown-mobile nav.elementor-nav-menu--dropdown');
        jQuery('header .accountino-support-widget').clone().appendTo('.elementor-nav-menu--dropdown-mobile nav.elementor-nav-menu--dropdown');
    }, 1000);
})