<?php

/**
 * Plugin Name: AccountPro Core
 * Description: پنل و ابزارک‌های سفارشی المنتور.
 * Version: 1.1.0
 * Author: Vahid Jahangir
 * Text Domain: accountino-core
 */

if (! defined('ABSPATH')) {
    exit;
}


define('ACCOUNTINO_CORE_VERSION', '1.0.0');
define('ACCOUNTINO_CORE__FILE__', __FILE__);
define('ACCOUNTINO_CORE_PLUGIN_BASE', plugin_basename(ACCOUNTINO_CORE__FILE__));
define('ACCOUNTINO_CORE_WIDGETS_PANEL', 'accountino-widgets');
define('ACCOUNTINO_CORE_PATH', plugin_dir_path(ACCOUNTINO_CORE__FILE__));

define('ACCOUNTINO_CORE_URL', plugins_url('/', ACCOUNTINO_CORE__FILE__));
define('ACCOUNTINO_CORE_ASSETS_URL', ACCOUNTINO_CORE_URL . 'assets/');
define('ACCOUNTINO_CORE_PANEL_CATEGORY', 'accountino_category');


/**
 * Load gettext translate for our text domain.
 *
 * @since 1.0.0
 *
 * @return void
 */
function accountino_core_load_plugin()
{
    load_plugin_textdomain('accountin-core');

    require ACCOUNTINO_CORE_PATH . '/plugin.php';

    require ACCOUNTINO_CORE_PATH . 'elementor_widgets/widgets.php';
    new AccountinoCore\Elementor_Widgets_Manager();
}

add_action('plugins_loaded', 'accountino_core_load_plugin');

add_action('elementor/init', function () {
    \Elementor\Plugin::instance()->elements_manager->add_category(
        ACCOUNTINO_CORE_PANEL_CATEGORY,
        [
            'title' => __('⭐ ابزارک های اکانت پرو', ACCOUNTINO_CORE_WIDGETS_PANEL),
            'icon'  => 'fa fa-plug',
        ]
    );
});
